/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.shellframework;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.ShellContext;
import ow.tool.util.shellframework.ShellServer;

public final class Shell<T>
implements Runnable,
Interruptible {
    public static final String CRLF = "\r\n";
    private Socket sock;
    private final ShellServer<T> shellServer;
    private BufferedInputStream in;
    private PrintStream out;
    private Thread selfThread = null;
    private final Map<String, Command<T>> commandTable;
    private final List<Command<T>> commandList;
    private final MessagePrinter showPromptPrinter;
    private final MessagePrinter noCommandPrinter;
    private final MessagePrinter emptyLinePrinter;
    private final T appDepData;
    private boolean interactive;
    private int bufSize = 8;
    private byte[] buf = new byte[this.bufSize];

    protected Shell(Socket sock, ShellServer<T> shellServer, Map<String, Command<T>> commandTable, List<Command<T>> commandList, MessagePrinter showPromptPrinter, MessagePrinter noCommandPrinter, MessagePrinter emptyLinePrinter, T applicationDependentData) throws Exception {
        this.sock = sock;
        this.shellServer = shellServer;
        InputStream sockInStream = sock.getInputStream();
        this.in = new BufferedInputStream(sockInStream);
        this.out = new PrintStream(sock.getOutputStream(), false);
        this.commandTable = commandTable;
        this.commandList = commandList;
        this.showPromptPrinter = showPromptPrinter;
        this.noCommandPrinter = noCommandPrinter;
        this.emptyLinePrinter = emptyLinePrinter;
        this.appDepData = applicationDependentData;
        this.interactive = true;
    }

    public Shell(InputStream in, PrintStream out, Map<String, Command<T>> commandTable, List<Command<T>> commandList, MessagePrinter showPromptPrinter, MessagePrinter noCommandPrinter, MessagePrinter emptyLinePrinter, T applicationDependentData, boolean interactive) {
        this(in, out, new ShellServer<T>(commandTable, commandList, showPromptPrinter, noCommandPrinter, emptyLinePrinter, applicationDependentData, -1), applicationDependentData, interactive);
    }

    public Shell(InputStream in, PrintStream out, ShellServer<T> shellServer, T applicationDependentData, boolean interactive) {
        this.sock = null;
        this.shellServer = shellServer;
        if (in != null) {
            this.in = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        }
        this.out = out;
        this.commandTable = this.shellServer.getCommandTable();
        this.commandList = this.shellServer.getCommandList();
        this.showPromptPrinter = this.shellServer.getShowPromptPrinter();
        this.noCommandPrinter = this.shellServer.getNoCommandPrinter();
        this.emptyLinePrinter = this.shellServer.getEmptyLinePrinter();
        this.appDepData = applicationDependentData;
        this.interactive = interactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object commandLine;
        boolean quit;
        this.selfThread = Thread.currentThread();
        if (this.shellServer != null) {
            Set<PrintStream> set = this.shellServer.outputStreamSet;
            synchronized (set) {
                this.shellServer.outputStreamSet.add(this.out);
            }
            this.shellServer.addInterruptible(this);
        }
        do {
            if (this.interactive && this.showPromptPrinter != null) {
                this.showPromptPrinter.execute(this.out, null);
            }
            commandLine = null;
            try {
                commandLine = this.readLineString();
            }
            catch (IOException e) {
                System.err.print("An Exception thrown when reading from a network.\r\n");
                e.printStackTrace(System.err);
            }
        } while (!(quit = this.parseALine((String)commandLine)));
        if (this.shellServer != null) {
            commandLine = this.shellServer.outputStreamSet;
            synchronized (commandLine) {
                this.shellServer.outputStreamSet.remove(this.out);
            }
            this.shellServer.removeInterruptible(this);
        }
        if (this.sock != null) {
            int retry = 3;
            while (retry-- > 0) {
                try {
                    this.sock.close();
                    this.sock = null;
                    break;
                }
                catch (IOException e) {
                    System.err.print("SocketChannel#close() threw an IOException.\r\n");
                }
            }
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            System.err.print("close() threw an IOException.\r\n");
        }
    }

    private synchronized String readLineString() throws IOException {
        int len = this.readLineBytes(0, false);
        if (len == -1) {
            return null;
        }
        return new String(this.buf, 0, len, "US-ASCII");
    }

    private int readLineBytes(int minLen, boolean recognizeEscape) throws IOException {
        int index = 0;
        while (true) {
            int b;
            if ((b = this.in.read()) == -1) {
                if (index != 0) break;
                index = -1;
                break;
            }
            if (index >= minLen) {
                if (b == 10) break;
                if (b == 13) {
                    this.in.mark(1);
                    int next = this.in.read();
                    if (next == 10 || next == 0) break;
                    this.in.reset();
                    break;
                }
                if (recognizeEscape && b == 92) {
                    int next = this.in.read();
                    switch (next) {
                        case 98: {
                            b = 8;
                            break;
                        }
                        case 116: {
                            b = 9;
                            break;
                        }
                        case 110: {
                            b = 10;
                            break;
                        }
                        case 102: {
                            b = 12;
                            break;
                        }
                        case 92: {
                            b = 92;
                            break;
                        }
                        case 114: {
                            b = 13;
                            break;
                        }
                    }
                }
            }
            if (index >= this.bufSize) {
                byte[] newBuf = null;
                try {
                    newBuf = new byte[this.bufSize << 1];
                }
                catch (OutOfMemoryError e) {
                    System.out.println(new String(this.buf, 0, 16, "US-ASCII"));
                    throw e;
                }
                System.arraycopy(this.buf, 0, newBuf, 0, this.bufSize);
                this.bufSize <<= 1;
                this.buf = newBuf;
            }
            this.buf[index++] = (byte)b;
        }
        return index;
    }

    public synchronized byte[] readLine(int minLen) throws IOException {
        int len = this.readLineBytes(minLen, false);
        if (len == -1) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(this.buf, 0, ret, 0, len);
        return ret;
    }

    private boolean parseALine(String commandLine) {
        if (commandLine == null) {
            return true;
        }
        if (commandLine.length() > 0 && commandLine.charAt(0) == '\u0000') {
            commandLine = commandLine.substring(1);
        }
        String[] tokens = commandLine.split("\\s+");
        int k = 0;
        while (k < tokens.length) {
            if (tokens[k].length() > 0) break;
            ++k;
        }
        if (k >= tokens.length) {
            if (this.emptyLinePrinter != null) {
                this.emptyLinePrinter.execute(this.out, null);
            }
            return false;
        }
        String cmdToken = tokens[k];
        if (cmdToken.startsWith("#") || cmdToken.startsWith("%") || cmdToken.startsWith("//")) {
            return false;
        }
        Command<T> command = this.commandTable.get(cmdToken);
        if (command == null) {
            if (this.noCommandPrinter != null) {
                this.noCommandPrinter.execute(this.out, cmdToken);
            }
            return false;
        }
        String[] args = new String[tokens.length - ++k];
        int i = 0;
        while (i < args.length) {
            args[i] = tokens[k];
            ++i;
            ++k;
        }
        ShellContext<T> context = new ShellContext<T>(this.shellServer, this, this.appDepData, this.out, this.commandList, cmdToken, args, this.interactive);
        boolean quit = false;
        try {
            quit = command.execute(context);
        }
        catch (Throwable e) {
            this.out.print("An Exception thrown: \r\n");
            e.printStackTrace(this.out);
            this.out.flush();
        }
        return quit;
    }

    @Override
    public void interrupt() {
        if (this.selfThread != null && !this.selfThread.equals(Thread.currentThread())) {
            this.selfThread.interrupt();
        }
    }

    public Writer getWriter() {
        return new ShellWriter();
    }

    public class ShellWriter
    extends Writer {
        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String str = new String(cbuf, off, len);
            Shell.this.parseALine(str);
        }
    }
}

