/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework;

import java.awt.BasicStroke;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.swing.ImageIcon;
import ow.id.ID;
import ow.tool.util.vizframework.GeometryManager;
import ow.tool.util.vizframework.VisualizerUtil;

class ImageManager {
    public static final int NUM_NODE_IMAGES = 3;
    public static final String[] NODE_IMAGE_NAMES = new String[]{"resources/node0.gif", "resources/node1.gif", "resources/node2.gif"};
    public static final int NUM_MARK_IMAGES = 1;
    public static final String[] MARK_IMAGE_NAMES = new String[]{"resources/mark0.gif"};
    private double scale;
    private double imageScale;
    GeometryManager geometryManager;
    private final Image[] origNodeImage;
    private final int[] origNodeWidth;
    private final int[] origNodeHeight;
    private final Image[] origMarkImage;
    private final int[] origMarkWidth;
    private final int[] origMarkHeight;
    private Image[] nodeImage;
    private int[] nodeWidth;
    private int[] nodeHeight;
    private Image[] markImage;
    private int[] markWidth;
    private int[] markHeight;
    private Stroke strokeForMessaging;
    private Stroke strokeForConnection;

    protected ImageManager() {
        URL iconURL;
        ClassLoader cl = ImageManager.class.getClassLoader();
        ImageIcon icon = null;
        this.origNodeImage = new Image[3];
        this.origNodeWidth = new int[3];
        this.origNodeHeight = new int[3];
        this.nodeImage = new Image[3];
        this.nodeWidth = new int[3];
        this.nodeHeight = new int[3];
        int i = 0;
        while (i < 3) {
            iconURL = cl.getResource(NODE_IMAGE_NAMES[i]);
            if (iconURL == null) {
                VisualizerUtil.fatal(String.valueOf(NODE_IMAGE_NAMES[i]) + " not found.");
            }
            icon = new ImageIcon(iconURL);
            this.origNodeImage[i] = icon.getImage();
            this.origNodeWidth[i] = icon.getIconWidth();
            this.origNodeHeight[i] = icon.getIconHeight();
            ++i;
        }
        this.origMarkImage = new Image[1];
        this.origMarkWidth = new int[1];
        this.origMarkHeight = new int[1];
        this.markImage = new Image[1];
        this.markWidth = new int[1];
        this.markHeight = new int[1];
        i = 0;
        while (i < 1) {
            iconURL = cl.getResource(MARK_IMAGE_NAMES[i]);
            if (iconURL == null) {
                VisualizerUtil.fatal(String.valueOf(MARK_IMAGE_NAMES[i]) + " not found.");
            }
            icon = new ImageIcon(iconURL);
            this.origMarkImage[i] = icon.getImage();
            this.origMarkWidth[i] = icon.getIconWidth();
            this.origMarkHeight[i] = icon.getIconHeight();
            ++i;
        }
        this.setScale(1.0);
    }

    public GeometryManager getGeometryManager() {
        return this.geometryManager;
    }

    public synchronized GeometryManager setGeometryManager(GeometryManager gm) {
        GeometryManager old = this.geometryManager;
        this.geometryManager = gm;
        return old;
    }

    public synchronized void setScale(double scale) {
        this.setImageScale(scale);
        if (scale <= 0.0 || scale == this.scale) {
            return;
        }
        this.scale = scale;
        if (this.geometryManager != null) {
            this.geometryManager.setScale(this.scale);
        }
    }

    public synchronized void setImageScale(double scale) {
        if (scale <= 0.0 || scale == this.imageScale) {
            return;
        }
        this.imageScale = scale;
        int i = 0;
        while (i < this.origNodeImage.length) {
            this.nodeWidth[i] = (int)((double)this.origNodeWidth[i] * scale);
            this.nodeHeight[i] = (int)((double)this.origNodeHeight[i] * scale);
            this.nodeImage[i] = this.origNodeImage[i].getScaledInstance(this.nodeWidth[i], this.nodeHeight[i], 4);
            ++i;
        }
        i = 0;
        while (i < this.origMarkImage.length) {
            this.markWidth[i] = (int)((double)this.origMarkWidth[i] * scale);
            this.markHeight[i] = (int)((double)this.origMarkHeight[i] * scale);
            this.markImage[i] = this.origMarkImage[i].getScaledInstance(this.markWidth[i], this.markHeight[i], 4);
            ++i;
        }
        float lineWidth = (float)(2.0 * scale);
        if (lineWidth < 1.0f) {
            lineWidth = 1.0f;
        }
        this.strokeForMessaging = new BasicStroke(lineWidth);
        lineWidth = (float)(2.5 * scale);
        if (lineWidth < 1.0f) {
            lineWidth = 1.0f;
        }
        this.strokeForConnection = new BasicStroke(lineWidth);
    }

    public Point getNodeLocation(ID id, int type) {
        Point2D p = this.geometryManager.getNodePoint2D(id);
        double x = p.getX();
        double y = p.getY();
        return new Point((int)(x -= (double)(this.nodeWidth[type] / 2)), (int)(y -= (double)(this.nodeHeight[type] / 2)));
    }

    public Point getMarkLocation(ID id, int type) {
        Point2D p = this.geometryManager.getNodePoint2D(id);
        double x = p.getX();
        double y = p.getY();
        return new Point((int)(x -= (double)(this.markWidth[type] / 2)), (int)(y -= (double)(this.markHeight[type] / 2)));
    }

    public Image getNodeImage(int type) {
        Image ret;
        try {
            ret = this.nodeImage[type];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ret = this.nodeImage[0];
        }
        return ret;
    }

    public int getNodeWidth(int type) {
        return this.nodeWidth[type];
    }

    public int getNodeHeight(int type) {
        return this.nodeHeight[type];
    }

    public Image getMarkImage(int type) {
        Image ret;
        try {
            ret = this.markImage[type];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ret = this.markImage[0];
        }
        return ret;
    }

    public int getMarkWidth(int type) {
        return this.markWidth[type];
    }

    public int getMarkHeight(int type) {
        return this.markHeight[type];
    }

    public Stroke getStrokeForMessaging() {
        return this.strokeForMessaging;
    }

    public Stroke getStrokeForConnection() {
        return this.strokeForConnection;
    }
}

