/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;
import ow.id.ID;
import ow.messaging.MessagingAddress;
import ow.tool.util.vizframework.ImageManager;

final class NodePanel
extends JComponent {
    private final ImageManager imageManager;
    private final ID id;
    private int type;
    private long emphasizedTime;
    private Point location;

    NodePanel(ImageManager imageManager, ID id, MessagingAddress address) {
        this.imageManager = imageManager;
        this.id = id;
        this.type = 0;
        this.resetSize();
        this.setToolTipText(address.toString());
    }

    boolean isEmphasized() {
        return this.type != 0;
    }

    long getEmphasizedTime() {
        return this.emphasizedTime;
    }

    void emphasize() {
        this.type = 1;
        this.emphasizedTime = System.currentTimeMillis();
    }

    void mark() {
        this.type = 2;
        this.emphasizedTime = System.currentTimeMillis();
    }

    void deemphasize() {
        this.type = 0;
    }

    protected void resetSize() {
        this.setSize(this.imageManager.getNodeWidth(this.type), this.imageManager.getNodeHeight(this.type));
        this.resetLocation();
    }

    protected void resetLocation() {
        this.location = this.imageManager.getNodeLocation(this.id, this.type);
        this.setLocation(this.location);
    }

    @Override
    protected void paintComponent(Graphics g) {
    }

    protected void drawComponent(Graphics g) {
        Image img = this.imageManager.getNodeImage(this.type);
        g.drawImage(img, this.location.x, this.location.y, this);
    }
}

