/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework.geom;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import ow.tool.util.vizframework.LineType;
import ow.tool.util.vizframework.Visualizer;
import ow.tool.util.vizframework.geom.AbstractGeometryManager;

public abstract class AbstractCircleGeometryManager
extends AbstractGeometryManager {
    private static final double DEFAULT_ID_CIRCLE_RADIUS = 230.0;
    private double idCircleRadius;

    public AbstractCircleGeometryManager() {
        this(160);
    }

    private AbstractCircleGeometryManager(int idSizeInBit) {
        super(idSizeInBit);
    }

    @Override
    public synchronized void setScale(double scale) {
        super.setScale(scale);
        this.idCircleRadius = 230.0 * scale;
    }

    Shape getShapeForLineBetweenTwoPoints(double fromDbl, double fromHeight, double toDbl, double toHeight, double ctrlHeight, double ctrlPhase) {
        Shape shape;
        if (Visualizer.LINE_TYPE == LineType.BEZIER_CURVE) {
            double distance = toDbl - fromDbl;
            if (Math.abs(distance) > this.idSpaceSize * 0.5) {
                distance = distance > 0.0 ? (distance -= this.idSpaceSize) : (distance += this.idSpaceSize);
            }
            double ctrlDbl = fromDbl + distance * ctrlPhase;
            Point2D fromPoint = this.getNodePoint2D(fromDbl, fromHeight);
            Point2D toPoint = this.getNodePoint2D(toDbl, toHeight);
            Point2D ctrlPoint = this.getNodePoint2D(ctrlDbl, fromHeight * toHeight * 0.5 * ctrlHeight);
            shape = new QuadCurve2D.Double(fromPoint.getX(), fromPoint.getY(), ctrlPoint.getX(), ctrlPoint.getY(), toPoint.getX(), toPoint.getY());
        } else {
            Point2D fromPoint = this.getNodePoint2D(fromDbl, 1.0);
            Point2D toPoint = this.getNodePoint2D(toDbl, 1.0);
            shape = new Line2D.Double(fromPoint, toPoint);
        }
        return shape;
    }

    Point2D getNodePoint2D(double id, double radiusRatio) {
        double angle = this.getAngle(id);
        double radius = this.idCircleRadius * radiusRatio;
        return this.getRotatedPointByPolar(angle, radius);
    }
}

