/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework.geom;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.math.BigInteger;
import ow.id.ID;
import ow.tool.util.vizframework.geom.AbstractGeometryManager;

public abstract class AbstractLineGeometryManager
extends AbstractGeometryManager {
    private static final double DEFAULT_HALF_LINE_LENGTH = 240.0;
    double idSpaceSize;
    private double halfIDSpaceSize;
    private double halfLineLength;

    protected AbstractLineGeometryManager() {
        this(160);
    }

    protected AbstractLineGeometryManager(int idSizeInBit) {
        super(idSizeInBit);
    }

    @Override
    public void setIDSizeInBit(int idSizeInBit) {
        super.setIDSizeInBit(idSizeInBit);
        this.idSpaceSize = BigInteger.ONE.shiftLeft(idSizeInBit).doubleValue();
        this.halfIDSpaceSize = BigInteger.ONE.shiftLeft(idSizeInBit - 1).doubleValue();
    }

    @Override
    public synchronized void setScale(double scale) {
        super.setScale(scale);
        this.halfLineLength = 240.0 * scale;
    }

    Shape getShapeForMessage(ID src, ID dest, double heightBase) {
        Point2D srcPoint = this.getNodePoint2D(src);
        Point2D destPoint = this.getNodePoint2D(dest);
        double srcDbl = src.toBigInteger().doubleValue();
        double destDbl = dest.toBigInteger().doubleValue();
        double ctrlPointHeight = (destDbl - srcDbl) / this.idSpaceSize * 1.5;
        ctrlPointHeight = ctrlPointHeight >= 0.0 ? (ctrlPointHeight += 0.5) : (ctrlPointHeight -= 0.5);
        Point2D ctrlPoint = this.getNodePoint2D((srcDbl + destDbl) / 2.0, heightBase + ctrlPointHeight);
        return new QuadCurve2D.Double(srcPoint.getX(), srcPoint.getY(), ctrlPoint.getX(), ctrlPoint.getY(), destPoint.getX(), destPoint.getY());
    }

    Shape getShapeForConnection(ID from, ID to, double heightBase) {
        double toDbl;
        Point2D fromPoint = this.getNodePoint2D(from);
        Point2D toPoint = this.getNodePoint2D(to);
        double fromDbl = from.toBigInteger().doubleValue();
        double ctrlPointHeight = (fromDbl - (toDbl = to.toBigInteger().doubleValue())) / this.idSpaceSize * 1.3;
        ctrlPointHeight = ctrlPointHeight >= 0.0 ? (ctrlPointHeight += 0.4) : (ctrlPointHeight -= 0.4);
        Point2D ctrlPoint = this.getNodePoint2D((fromDbl + toDbl) / 2.0, heightBase + ctrlPointHeight);
        return new QuadCurve2D.Double(fromPoint.getX(), fromPoint.getY(), ctrlPoint.getX(), ctrlPoint.getY(), toPoint.getX(), toPoint.getY());
    }

    Point2D getNodePoint2D(double idDbl, double height) {
        double radius = (idDbl - this.halfIDSpaceSize) / this.halfIDSpaceSize;
        double angle = Math.atan2(radius, height);
        radius = Math.sqrt(radius * radius + height * height);
        return this.getRotatedPointByPolar(angle, radius *= this.halfLineLength);
    }
}

