<?xml version="1.0"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.4 $
																																					-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="yes" encoding="UTF-8"/>

	<!-- Overall parameters -->
	<xsl:param name="head.title">invoke.title</xsl:param>

	<!-- Request parameters -->
	<xsl:param name="request.objectname"/>
	<xsl:param name="request.method"/>

	<xsl:include href="common.xsl"/>

	<!-- Operation invoke -->
	<xsl:template name="operation" >
		<xsl:for-each select="Operation">
    <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
      <tr>
        <td>
          <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
        </td>
        <td align="left" bgcolor="#993399" nowrap="nowrap">
          <span class="Titre2">
             <font color="#FFFFFF">
              <b>
                <xsl:call-template name="str">
						      <xsl:with-param name="id">invoke.operation.title.1</xsl:with-param>
					      </xsl:call-template>
              </b>
            </font>
          </span>
        </td>
        <td>
          <img border="0" src="images/bkgd_onglet_tit.gif"/>
        </td>
        <td bgcolor="#660066" width="100%"/>
      </tr>
      <tr align="left" valign="top">
        <td colspan="4" bgcolor="#993399" class="Titre3black">
          <img height="15" src="images/poussoir.gif" width="100%"/>
        </td>
      </tr>
    </table>
		<table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
	    <tr>
        <td>
          <xsl:call-template name="str">
						<xsl:with-param name="id">invoke.operation.title.2</xsl:with-param>
						<xsl:with-param name="p0"><xsl:value-of select="$request.method"/></xsl:with-param>
						<xsl:with-param name="p1"><xsl:value-of select="$request.objectname"/></xsl:with-param>
					</xsl:call-template>
        </td>
      </tr>
			<tr>
				<td>
					<xsl:if test="@result='success'">
						<xsl:call-template name="str">
							<xsl:with-param name="id">invoke.operation.success</xsl:with-param>
						</xsl:call-template>
						<br/>
						<xsl:if test="not (@return='')">
							<xsl:call-template name="str">
								<xsl:with-param name="id">invoke.operation.success.result</xsl:with-param>
								<xsl:with-param name="p0"><xsl:value-of select="@return"/></xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="@return=''">
							<xsl:call-template name="str">
								<xsl:with-param name="id">invoke.operation.success.noresult</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</xsl:if>
					<xsl:if test="@result='error'">
						<xsl:call-template name="str">
							<xsl:with-param name="id">invoke.operation.success.error</xsl:with-param>
							<xsl:with-param name="p0"><xsl:value-of select="@errorMsg"/></xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</td>
			</tr>
			<xsl:call-template name="mbeanview">
				<xsl:with-param name="objectname" select="$request.objectname"/>
			</xsl:call-template>
		</table>
		</xsl:for-each>
	</xsl:template>

	<!-- Main template -->
	<xsl:template match="MBeanOperation" name="main">
		<html>
			<xsl:call-template name="head"/>
			<body topmargin="0" leftmargin="0" bgcolor="#FFFFFF" text="#000000" onLoad="MM_preloadImages('images/bkgd_onglet_contact_on.gif','images/btn_top_on.gif')">
				<xsl:call-template name="toprow">
					<xsl:with-param name="selection">mbean</xsl:with-param>
				</xsl:call-template>
				<table width="{$pageWidth}" border="0" cellspacing="0" cellpadding="0">
          <tr bgcolor="#660066"> 
            <td height="17"/>
            <td class="titre1" height="17" valign="middle" align="right">
              <img src="images/titres/tit_mbean_{$request.locale}.gif"/>
            </td>
          </tr>
        </table>
				<xsl:call-template name="operation"/>
				<xsl:call-template name="bottom"/>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>

