/*
 * Decompiled with CFR 0.152.
 */
package com.dokukino.genkidama;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import ow.dht.DHT;
import ow.tool.dhtshell.commands.ClearCommand;
import ow.tool.dhtshell.commands.GetCommand;
import ow.tool.dhtshell.commands.HaltCommand;
import ow.tool.dhtshell.commands.HelpCommand;
import ow.tool.dhtshell.commands.InitCommand;
import ow.tool.dhtshell.commands.LocaldataCommand;
import ow.tool.dhtshell.commands.PutCommand;
import ow.tool.dhtshell.commands.QuitCommand;
import ow.tool.dhtshell.commands.RemoveCommand;
import ow.tool.dhtshell.commands.ResumeCommand;
import ow.tool.dhtshell.commands.SetSecretCommand;
import ow.tool.dhtshell.commands.SetTTLCommand;
import ow.tool.dhtshell.commands.StatusCommand;
import ow.tool.dhtshell.commands.SuspendCommand;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;

public class DHTShellServer {
    private static final int SHELL_PORT = -1;
    private static final Class[] COMMANDS = new Class[]{StatusCommand.class, InitCommand.class, GetCommand.class, PutCommand.class, RemoveCommand.class, SetTTLCommand.class, SetSecretCommand.class, LocaldataCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class, ClearCommand.class, SuspendCommand.class, ResumeCommand.class};
    private static final List<Command<DHT<String>>> commandList = ShellServer.createCommandList(COMMANDS);
    private static final Map<String, Command<DHT<String>>> commandTable = ShellServer.createCommandTable(commandList);

    public static void start(DHT<String> dht) {
        ShellServer<DHT<String>> shellServ = new ShellServer<DHT<String>>(commandTable, commandList, new ShowPromptPrinter(), new NoCommandPrinter(), null, dht, -1, null);
        Shell<DHT<String>> stdioShell = new Shell<DHT<String>>(System.in, System.out, shellServ, dht, true);
        Thread shellThread = new Thread(stdioShell);
        shellThread.start();
    }

    private static class NoCommandPrinter
    implements MessagePrinter {
        private NoCommandPrinter() {
        }

        @Override
        public void execute(PrintStream out, String hint) {
            out.print("No such command");
            if (hint != null) {
                out.print(": " + hint);
            } else {
                out.print(".");
            }
            out.print("\r\n");
            out.flush();
        }
    }

    private static class ShowPromptPrinter
    implements MessagePrinter {
        private ShowPromptPrinter() {
        }

        @Override
        public void execute(PrintStream out, String hint) {
            out.print("Ready.\r\n");
            out.flush();
        }
    }
}

