/*
 * Decompiled with CFR 0.152.
 */
package com.dokukino.genkidama;

import com.dokukino.genkidama.GenkidamaManager;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.processor.HttpUtil;
import dareka.processor.impl.Cache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.positrium.waket.URLMap;
import org.positrium.waket.XMLConfigLoader;

public class DataServer {
    public static Log logger = LogFactory.getLog(DataServer.class);
    XMLConfigLoader loader = new XMLConfigLoader(new File("DataServer.xml"));

    public void bind(int port) throws IOException {
        HttpHandler nicoCacheHandler = new HttpHandler(){

            @Override
            public void handle(HttpExchange he) throws IOException {
                String cacheid = he.getRequestURI().getPath().replaceFirst("^/nc/", "");
                Cache cache = new Cache(cacheid, null);
                logger.info("cache requested: " + cacheid);
                if (cache.exists() && !GenkidamaManager.checkDeleted(cache.getId())) {
                    logger.info("publishing cache: " + cache.getCacheFileName());
                    he.getResponseHeaders().set("Content-Type", "video/flv");
                    he.sendResponseHeaders(200, cache.length());
                    OutputStream out = he.getResponseBody();
                    InputStream in = cache.getInputStream();
                    try {
                        HttpUtil.sendBody(out, in, cache.length());
                    }
                    finally {
                        CloseUtil.close(out);
                        CloseUtil.close(in);
                    }
                } else {
                    he.sendResponseHeaders(404, 0L);
                    he.getRequestBody().close();
                }
            }
        };
        HttpHandler proxyPacHandler = new HttpHandler(){

            @Override
            public void handle(HttpExchange he) throws IOException {
                File file = new File(Config.getString("dhtProxyPac", "proxy.pac"));
                he.sendResponseHeaders(200, file.length());
                he.getResponseHeaders().set("Content-Type", "text/plain");
                if (file.exists()) {
                    OutputStream out = he.getResponseBody();
                    FileInputStream in = new FileInputStream(file);
                    try {
                        HttpUtil.sendBody(out, in, file.length());
                    }
                    finally {
                        CloseUtil.close(out);
                        CloseUtil.close(in);
                    }
                } else {
                    he.sendResponseHeaders(404, 0L);
                    he.getRequestBody().close();
                }
            }
        };
        List list = this.loader.getMap().getURLMap();
        HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
        server.createContext("/nc/", nicoCacheHandler);
        server.createContext("/proxy.pac", proxyPacHandler);
        for (URLMap bean : list) {
            HttpHandler handleObject = null;
            try {
                handleObject = (HttpHandler)Class.forName(bean.getClassname()).newInstance();
            }
            catch (InstantiationException e) {
                logger.error("Error Occurs:", e);
            }
            catch (IllegalAccessException e) {
                logger.error("Error Occurs:", e);
            }
            catch (ClassNotFoundException e) {
                logger.error("Error Occurs:", e);
            }
            server.createContext(bean.getUrl(), handleObject);
        }
        server.start();
    }
}

