/*
 * Decompiled with CFR 0.152.
 */
package com.dokukino.genkidama;

import com.dokukino.genkidama.GenkidamaManager;
import com.dokukino.genkidama.XmlRpcInvoker;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;

public class PutTask
implements Runnable {
    public static Log logger = LogFactory.getLog(PutTask.class);
    private String id;

    public PutTask(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            GenkidamaManager manager = GenkidamaManager.getInstance();
            if (logger.isDebugEnabled()) {
                logger.debug("PutTask takes " + this.id);
            }
            while (!manager.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("PutTask waiting connection");
                }
                try {
                    ExecutorService putExecutor;
                    ExecutorService executorService = putExecutor = manager.getPutExecutor();
                    synchronized (executorService) {
                        putExecutor.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ID key = ID.getSHA1BasedID(("nc:" + this.id).getBytes());
            logger.info("DHT put: nc:" + this.id);
            String uri = "http://" + manager.getExternalAddress() + ":" + manager.getDataPort() + "/nc/" + this.id;
            while (true) {
                try {
                    manager.getDht().put(key, uri);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Error Occurs:", e);
                    continue;
                }
                break;
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(manager.getRingPort());
            params.add(4);
            params.add("nc:" + this.id);
            try {
                XmlRpcInvoker.invokeAsync("onlineData.register", params);
            }
            catch (MalformedURLException e) {
                if (!logger.isErrorEnabled()) break block13;
                logger.error("Error Occurs:", e);
            }
        }
    }
}

