/*
 * Decompiled with CFR 0.152.
 */
package com.dokukino.genkidama;

import com.dokukino.genkidama.XmlRpcInvoker;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.device.DeviceChangeListener;
import ow.messaging.upnp.Mapping;

public final class UPnPTest {
    public static Log logger = LogFactory.getLog(UPnPTest.class);
    private static final String ROUTER_DEV = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEV = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEV = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WANIPCON_SERV = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String WANPPPCON_SERV = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private static UPnPTest singletonInstance = new UPnPTest();
    private ControlPoint cp;
    private Device dev;
    private Service serv;
    private final Set<Mapping> registeredMappings = new HashSet<Mapping>();
    private static final int RING_PORT = 50000;
    private static final int DATA_PORT = 50001;

    public static UPnPTest getInstance() {
        return singletonInstance;
    }

    public static void main(String[] args) throws UnknownHostException {
        UPnPTest instance = new UPnPTest();
        instance.start();
        while (!instance.waitForDeviceFound(1000L)) {
            System.err.println("wait for device found timeout, retrying");
            instance.stop();
            instance.start();
        }
        Mapping map = new Mapping(50000, InetAddress.getLocalHost().getHostAddress(), 50000, Mapping.Protocol.TCP, "Genkidama ring port");
        if (!instance.addMapping(map)) {
            System.err.println("add mapping failed");
            System.exit(1);
        }
        System.out.println(String.valueOf(InetAddress.getLocalHost().getHostAddress()) + ":" + 50000 + " added");
        map = new Mapping(50001, InetAddress.getLocalHost().getHostAddress(), 50001, Mapping.Protocol.TCP, "Genkidama data port");
        if (!instance.addMapping(map)) {
            System.err.println("add mapping failed");
            System.exit(1);
        }
        System.out.println(String.valueOf(InetAddress.getLocalHost().getHostAddress()) + ":" + 50001 + " added");
        instance.stop();
    }

    public Device getDev() {
        return this.dev;
    }

    private UPnPTest() {
        this.cp = new ControlPoint();
    }

    public boolean start() {
        this.cp.addDeviceChangeListener((DeviceChangeListener)new DevChgListener());
        boolean ret = this.cp.start();
        logger.info("UPnP manager started.");
        return ret;
    }

    public void stop() {
        this.cp.stop();
    }

    public void waitForDeviceFound() {
        this.waitForDeviceFound(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForDeviceFound(long timeout) {
        UPnPTest uPnPTest = this;
        synchronized (uPnPTest) {
            block6: {
                if (!this.deviceFound()) break block6;
                return true;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.deviceFound();
    }

    private boolean deviceFound() {
        System.out.println("dev:" + this.dev + " serv:" + this.serv);
        return this.dev != null && this.serv != null;
    }

    public InetAddress getExternalAddress() throws MalformedURLException, XmlRpcException, UnknownHostException {
        String externalAddress = (String)XmlRpcInvoker.invoke("globalIp.probe", null);
        InetAddress ipAddr = InetAddress.getByName(externalAddress);
        return ipAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMapping(Mapping map) {
        if (!this.deviceFound()) {
            return false;
        }
        Action a = this.serv.getAction("AddPortMapping");
        if (a == null) {
            return false;
        }
        a.setArgumentValue("NewRemoteHost", "");
        a.setArgumentValue("NewExternalPort", map.getExternalPort());
        a.setArgumentValue("NewInternalClient", map.getInternalAddress());
        a.setArgumentValue("NewInternalPort", map.getInternalPort());
        a.setArgumentValue("NewProtocol", map.getProtocol().toString());
        String desc = map.getDescription();
        if (desc != null) {
            a.setArgumentValue("NewPortMappingDescription", desc);
        }
        a.setArgumentValue("NewEnabled", "1");
        a.setArgumentValue("NewLeaseDuration", 0);
        boolean succeed = a.postControlAction();
        if (succeed) {
            Set<Mapping> set = this.registeredMappings;
            synchronized (set) {
                this.registeredMappings.add(map);
            }
        }
        logger.info("UPnP address port mapping " + (succeed ? "succeeded" : "failed") + ": ext port " + map.getExternalPort() + ", internal port " + map.getInternalPort());
        return succeed;
    }

    public boolean deleteMapping(int externalPort, Mapping.Protocol protocol) {
        Mapping map = new Mapping(externalPort, null, 0, protocol, null);
        return this.deleteMapping(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMapping(Mapping map) {
        if (!this.deviceFound()) {
            return false;
        }
        Action a = this.serv.getAction("DeletePortMapping");
        if (a == null) {
            return false;
        }
        a.setArgumentValue("NewRemoteHost", "");
        a.setArgumentValue("NewExternalPort", map.getExternalPort());
        a.setArgumentValue("NewProtocol", map.getProtocol().toString());
        boolean succeed = a.postControlAction();
        if (succeed) {
            Set<Mapping> set = this.registeredMappings;
            synchronized (set) {
                this.registeredMappings.remove(map);
            }
        }
        logger.info("UPnP address port mapping " + (succeed ? "deleted" : "deletion failed") + ": ext port " + map.getExternalPort());
        return succeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMapping() {
        Mapping[] maps;
        if (!this.deviceFound()) {
            return;
        }
        Set<Mapping> set = this.registeredMappings;
        synchronized (set) {
            int size = this.registeredMappings.size();
            if (size <= 0) {
                return;
            }
            maps = new Mapping[size];
            this.registeredMappings.toArray(maps);
        }
        Mapping[] mappingArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping m = mappingArray[n2];
            this.deleteMapping(m.getExternalPort(), m.getProtocol());
            ++n2;
        }
    }

    private class DevChgListener
    implements DeviceChangeListener {
        private DevChgListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceAdded(Device dev) {
            System.out.println("dev:" + dev);
            if (UPnPTest.this.deviceFound()) {
                return;
            }
            if (!dev.getDeviceType().equals(UPnPTest.ROUTER_DEV) || !dev.isRootDevice()) {
                return;
            }
            UPnPTest.this.dev = dev;
            for (Object o1 : dev.getDeviceList()) {
                Device d1 = (Device)o1;
                if (!d1.getDeviceType().equals(UPnPTest.WAN_DEV)) continue;
                for (Object o2 : d1.getDeviceList()) {
                    Device d2 = (Device)o2;
                    if (!d2.getDeviceType().equals(UPnPTest.WANCON_DEV)) continue;
                    UPnPTest.this.serv = d2.getService(UPnPTest.WANIPCON_SERV);
                    if (UPnPTest.this.serv == null) {
                        UPnPTest.this.serv = d2.getService(UPnPTest.WANPPPCON_SERV);
                    }
                    logger.info("UPnP device found: " + dev.getFriendlyName());
                    UPnPTest uPnPTest = UPnPTest.this;
                    synchronized (uPnPTest) {
                        UPnPTest.this.notifyAll();
                    }
                }
            }
        }

        public void deviceRemoved(Device dev) {
        }
    }
}

