/*
 * Decompiled with CFR 0.152.
 */
package dareka;

import com.dokukino.genkidama.GenkidamaManager;
import com.dokukino.genkidama.VersionInfo;
import com.dokukino.genkidama.XmlRpcInvoker;
import dareka.Server;
import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.processor.impl.Cache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.positrium.chikarawo.Chikarawo;
import org.positrium.chikarawo.ErrorDialog;
import ow.routing.RoutingException;

public class Main {
    public static Log logger = LogFactory.getLog(Main.class);
    public static final String VER_STRING = VersionInfo.getFullVersion();
    private static Server server;
    private static Chikarawo gui;

    public static void stop() throws RoutingException {
        logger.info("Shutting down");
        if (server != null) {
            server.stop();
        }
        if (GenkidamaManager.getInstance().isConnected()) {
            GenkidamaManager.getInstance().disconnect();
        }
    }

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Main.stop();
                }
                catch (RoutingException e) {
                    logger.error("Error Occurs:", e);
                }
            }
        });
        gui = new Chikarawo();
        gui.openTray();
        try {
            Main.mainBody();
        }
        catch (Exception e) {
            logger.error("Error Occurs:", e);
            new ErrorDialog("Error", e.toString());
        }
    }

    private static void mainBody() throws Exception {
        File defFile;
        File configFile = new File("config.ini");
        if (!configFile.exists()) {
            configFile = new File("config.properties");
        }
        if (!configFile.exists() && (defFile = new File("config.properties.default")).exists()) {
            defFile.renameTo(configFile);
        }
        Config config = Main.configure(configFile);
        logger.info(VER_STRING);
        logger.info("port=" + Integer.getInteger("listenPort"));
        if (System.getProperty("proxyHost").equals("")) {
            logger.info("direct mode (no secondary proxy)");
        } else {
            logger.info("proxy host=" + System.getProperty("proxyHost"));
            logger.info("proxy port=" + Integer.getInteger("proxyPort"));
        }
        logger.info("title=" + Boolean.getBoolean("title"));
        if (Boolean.getBoolean("resumeDownload")) {
            logger.info("Resume suspended download On");
        }
        if (Boolean.getBoolean("touchCache")) {
            logger.info("Touch Cache File On");
        }
        HashMap versionCheckResult = (HashMap)XmlRpcInvoker.invoke("version.check", null);
        String versionUpUrl = (String)versionCheckResult.get("version_up_url");
        if ((Integer)versionCheckResult.get("required_version") > 4) {
            logger.info("You need to version up the program in following URL:\n" + versionUpUrl);
            return;
        }
        if ((Integer)versionCheckResult.get("newest_version") > 4) {
            logger.info("New version found:\n" + versionUpUrl);
        }
        GenkidamaManager.getInstance().connect();
        Cache.init();
        logger.info(String.format("total self cache size=%,dbytes\n", Cache.size()));
        server = new Server(config);
        server.start();
    }

    private static Config configure(File configFile) throws IOException {
        Properties p = new Properties();
        Main.setDefaults(p);
        Config config = new Config();
        if (configFile.exists()) {
            Main.loadFrom(configFile, p);
        } else {
            p.setProperty("dhtSecret", RandomStringUtils.randomAlphanumeric(40));
            FileOutputStream out = new FileOutputStream(configFile);
            try {
                p.store(out, "NicoCache config file");
            }
            finally {
                CloseUtil.close(out);
            }
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            System.setProperty(key, value.trim());
        }
        return config;
    }

    private static void loadFrom(File configFile, Properties p) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(configFile);
        try {
            p.load(in);
        }
        finally {
            CloseUtil.close(in);
        }
    }

    private static void setDefaults(Properties p) {
        try {
            Main.setDefaultsFromFiles(p);
            if (p.size() > 0) {
                return;
            }
        }
        catch (IOException e) {
            logger.debug(e);
        }
        p.setProperty("listenPort", "8080");
        p.setProperty("proxyHost", "");
        p.setProperty("proxyPort", "8081");
        p.setProperty("title", "true");
        p.setProperty("touchCache", "true");
    }

    private static void setDefaultsFromFiles(Properties p) throws IOException {
        File defaultsDir = new File("defaults");
        Object[] files = defaultsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        if (files == null) {
            throw new IOException("failed to read: " + defaultsDir);
        }
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            Main.loadFrom((File)f, p);
            ++n2;
        }
    }
}

