/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.processor.HttpRequestHeader;
import dareka.processor.HttpResponseHeader;
import dareka.processor.HttpUtil;
import dareka.processor.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLResource
extends Resource {
    public static Log logger = LogFactory.getLog(URLResource.class);
    private static final int BUFFERED_POST_MAX = 0;
    private URL url;
    private boolean followRedirects = false;
    private Proxy proxy;
    private long contentLength = -1L;
    private boolean canContinue = true;

    public URLResource(String resource) throws IOException {
        this.url = new URL(resource);
        String proxyHost = System.getProperty("proxyHost");
        int proxyPort = Integer.getInteger("proxyPort");
        this.setProxyNoOverride(proxyHost, proxyPort);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    @Override
    public boolean endEnsuredTransferTo(Socket receiver, HttpRequestHeader requestHeader, Config config) throws IOException {
        return this.transferTo(receiver.getInputStream(), receiver.getOutputStream(), requestHeader, config);
    }

    public boolean transferTo(InputStream receiverIn, OutputStream receiverOut, HttpRequestHeader requestHeaderArg, Config config) throws IOException {
        HttpRequestHeader requestHeader;
        if (requestHeaderArg == null) {
            requestHeader = new HttpRequestHeader("GET " + this.url.toString() + " HTTP/1.1\r\n\r\n");
            requestHeader.setMessageHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0)");
        } else {
            requestHeader = requestHeaderArg;
        }
        URLConnection con = this.url.openConnection(this.proxy);
        this.prepareForConnect(requestHeader, receiverIn, con);
        con.connect();
        try {
            InputStream in;
            this.sendBodyIfNeccessary(receiverIn, requestHeader, con);
            this.contentLength = con.getContentLength();
            boolean knownLengthContent = this.isKnownLengthContent(con);
            boolean clientCanKeepAlive = this.isClientCanKeepAlive(requestHeader);
            if (!knownLengthContent || !clientCanKeepAlive) {
                this.canContinue = false;
            }
            HttpResponseHeader responseHeader = this.getResponseHeader(con, requestHeader);
            this.execSendingHeaderSequence(receiverOut, responseHeader);
            try {
                in = con.getInputStream();
            }
            catch (IOException e) {
                logger.debug(e);
                if (con instanceof HttpURLConnection) {
                    HttpURLConnection hcon = (HttpURLConnection)con;
                    in = hcon.getErrorStream();
                    if (in == null) {
                        return this.canContinue;
                    }
                }
                throw e;
            }
            try {
                try {
                    this.execSendingBodySequence(receiverOut, in, this.contentLength);
                }
                catch (IOException e) {
                    logger.debug(e);
                    this.canContinue = false;
                    try {
                        if (this.contentLength < 102400L) {
                            this.consumeInputStream(in);
                        }
                    }
                    catch (IOException e1) {
                        logger.debug(e1);
                    }
                    CloseUtil.close(in);
                }
            }
            finally {
                CloseUtil.close(in);
            }
        }
        catch (IOException e) {
            logger.debug(e);
            this.canContinue = false;
            this.consumeErrorStream(con);
        }
        return this.canContinue;
    }

    @Override
    protected void doSetMandatoryResponseHeader(HttpResponseHeader responseHeader) {
        if (this.contentLength == -1L) {
            responseHeader.removeMessageHeader("Content-Length");
        } else {
            responseHeader.setContentLength(this.contentLength);
        }
        if (this.canContinue) {
            responseHeader.setMessageHeader("Connection", "keep-alive");
            if (this.contentLength != -1L) {
                responseHeader.setContentLength(this.contentLength);
            }
        } else {
            responseHeader.setMessageHeader("Connection", "close");
        }
    }

    private void setProxyNoOverride(String proxyHost, int proxyPort) {
        this.proxy = proxyHost == null || proxyHost.equals("") ? Proxy.NO_PROXY : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.setProxyNoOverride(proxyHost, proxyPort);
    }

    private boolean isKnownLengthContent(URLConnection con) throws IOException {
        if (this.contentLength == -1L) {
            if (con instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)con;
                int responseCode = hcon.getResponseCode();
                switch (responseCode) {
                    case 204: 
                    case 205: 
                    case 304: {
                        return true;
                    }
                }
                if ("HEAD".equals(hcon.getRequestMethod())) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private HttpResponseHeader getResponseHeader(URLConnection con, HttpRequestHeader requestHeader) throws IOException {
        HttpResponseHeader responseHeader;
        if (con instanceof HttpURLConnection) {
            responseHeader = new HttpResponseHeader(String.valueOf(con.getHeaderField(0)) + "\r\n\r\n");
            this.copyResponseHeaderFrom(con, responseHeader);
        } else {
            responseHeader = new HttpResponseHeader("HTTP/1.1 200 OK\r\n\r\n");
            String contentType = con.getHeaderField("Content-Type");
            if (contentType != null) {
                responseHeader.setMessageHeader("Content-Type", contentType);
            }
        }
        responseHeader.removeHopByHopHeaders();
        responseHeader.setVersion(requestHeader.getVersion());
        return responseHeader;
    }

    private void copyResponseHeaderFrom(URLConnection con, HttpResponseHeader responseHeader) {
        String value;
        int i = 0;
        while ((value = con.getHeaderField(i)) != null) {
            String key = con.getHeaderFieldKey(i);
            if (key != null) {
                responseHeader.addMessageHeader(key, value);
            }
            ++i;
        }
    }

    private void prepareForConnect(HttpRequestHeader requestHeader, InputStream receiverIn, URLConnection con) throws ProtocolException {
        long requestContentLength = requestHeader.getContentLength();
        this.prepareConfiguration(con);
        this.prepareMethod(requestHeader, receiverIn, con, requestContentLength);
        this.prepareHeaders(requestHeader, con);
    }

    private void prepareConfiguration(URLConnection con) {
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            hcon.setInstanceFollowRedirects(this.followRedirects);
        }
    }

    private void prepareMethod(HttpRequestHeader requestHeader, InputStream receiverIn, URLConnection con, long requestContentLength) throws ProtocolException {
        if (this.isShouldPost(requestHeader, receiverIn, requestContentLength)) {
            con.setDoOutput(true);
            if (requestContentLength > 0L && con instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)con;
                hcon.setFixedLengthStreamingMode((int)requestContentLength);
            }
        } else if (this.isShouldHead(requestHeader) && con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            hcon.setRequestMethod("HEAD");
        }
    }

    private boolean isShouldHead(HttpRequestHeader requestHeader) {
        return "HEAD".equals(requestHeader.getMethod());
    }

    private boolean isShouldPost(HttpRequestHeader requestHeader, InputStream receiverIn, long requestContentLength) {
        return receiverIn != null && (requestContentLength > 0L || "POST".equals(requestHeader.getMethod()));
    }

    private void prepareHeaders(HttpRequestHeader requestHeader, URLConnection con) {
        for (Map.Entry<String, List<String>> entry : requestHeader.getMessageHeaders().entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                con.addRequestProperty(key, value);
            }
        }
    }

    private void sendBodyIfNeccessary(InputStream receiverIn, HttpRequestHeader header, URLConnection con) throws IOException {
        if (con.getDoOutput()) {
            OutputStream out = con.getOutputStream();
            try {
                HttpUtil.sendBody(out, receiverIn, header.getContentLength());
            }
            finally {
                CloseUtil.close(out);
            }
        }
    }

    private void consumeErrorStream(URLConnection con) {
        block5: {
            try {
                HttpURLConnection hcon;
                InputStream es;
                if (!(con instanceof HttpURLConnection) || (es = (hcon = (HttpURLConnection)con).getErrorStream()) == null) break block5;
                try {
                    this.consumeInputStream(es);
                }
                finally {
                    CloseUtil.close(es);
                }
            }
            catch (IOException e) {
                logger.debug(e);
            }
        }
    }

    private void consumeInputStream(InputStream in) throws IOException {
        Thread currentThread = Thread.currentThread();
        byte[] buf = new byte[128];
        while (!currentThread.isInterrupted() && in.read(buf) != -1) {
        }
    }
}

