/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import com.dokukino.genkidama.GenkidamaManager;
import dareka.common.CloseUtil;
import dareka.processor.HttpResponseHeader;
import dareka.processor.TransferListener;
import dareka.processor.impl.Cache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NicoCachingListener
implements TransferListener {
    public static Log logger = LogFactory.getLog(NicoCachingListener.class);
    private static final int BUF_SIZE = 32768;
    private static final Pattern CONTENT_RANGE_VALUE_PATTERN = Pattern.compile("bytes (\\d+)-(\\d+)/(\\d+)");
    private Cache cache;
    private FutureTask<String> retrieveTitleTask;
    private OutputStream out;
    private boolean errorOccured;
    private boolean keepCacheOnError = false;
    InputStream cacheInput = null;
    int tmpSize = 0;
    boolean partial = false;
    boolean dupconnect = false;

    public NicoCachingListener(Cache cache, FutureTask<String> retrieveTitleTask, InputStream cacheInput, boolean dupconnect) {
        this.cache = cache;
        this.retrieveTitleTask = retrieveTitleTask;
        this.cacheInput = cacheInput;
        this.dupconnect = dupconnect;
        this.errorOccured = false;
    }

    @Override
    public void onResponseHeader(HttpResponseHeader responseHeader) {
        int statusCode;
        long contentLength = responseHeader.getContentLength();
        if (contentLength <= 0L) {
            this.errorOccured = true;
        }
        if ((statusCode = responseHeader.getStatusCode()) == 206) {
            String rangeValue = responseHeader.getMessageHeader("Content-Range");
            Matcher m = CONTENT_RANGE_VALUE_PATTERN.matcher(rangeValue);
            if (m.find()) {
                if (Integer.parseInt(m.group(2)) + 1 == Integer.parseInt(m.group(3))) {
                    logger.info("Partial download from " + m.group(1) + " byte");
                } else {
                    logger.info("Maybe Bad Responce: " + m.group(0));
                }
                contentLength = Long.parseLong(m.group(3));
                Cache.setDLFlag(this.cache.getId(), (int)contentLength);
                this.tmpSize = Integer.parseInt(m.group(1));
                this.partial = true;
            }
            responseHeader.setStatusCode(200, "OK");
            responseHeader.removeMessageHeader("Content-Range");
            responseHeader.removeMessageHeader("Accept-Range");
            responseHeader.setContentLength(contentLength);
        } else if (statusCode != 200) {
            this.errorOccured = true;
        }
        try {
            if (!this.errorOccured && !this.dupconnect) {
                this.out = this.cache.getTmpOutputStream(this.partial);
            }
        }
        catch (IOException e) {
            logger.warn(String.valueOf(this.cache.getCacheFileName()) + ": " + e.toString());
        }
    }

    @Override
    public void onTransferBegin(OutputStream bout) {
        if (this.partial && this.cacheInput != null) {
            try {
                try {
                    int len = 0;
                    int rest = this.tmpSize;
                    byte[] buf = new byte[32768];
                    while ((len = this.cacheInput.read(buf)) != -1) {
                        try {
                            bout.write(buf, 0, len < rest ? len : rest);
                        }
                        catch (IOException e) {
                            this.keepCacheOnError = true;
                            throw e;
                        }
                        rest -= len;
                    }
                }
                catch (IOException e) {
                    logger.warn(String.valueOf(this.cache.getCacheFileName()) + ": " + e.toString());
                    this.errorOccured = true;
                    if (!CloseUtil.close(this.cacheInput)) {
                        this.errorOccured = true;
                    }
                }
            }
            finally {
                if (!CloseUtil.close(this.cacheInput)) {
                    this.errorOccured = true;
                }
            }
        }
    }

    @Override
    public void onTransferring(byte[] buf, int length) {
        if (this.errorOccured || this.out == null) {
            return;
        }
        try {
            this.out.write(buf, 0, length);
        }
        catch (IOException e) {
            logger.warn(String.valueOf(this.cache.getCacheFileName()) + ": " + e.toString());
            this.errorOccured = true;
        }
    }

    @Override
    public void onTransferEnd(boolean completed) {
        block16: {
            if (this.dupconnect) {
                return;
            }
            Cache.setDLFlag(this.cache.getId(), -1);
            if (!CloseUtil.close(this.out)) {
                this.errorOccured = true;
            }
            try {
                if (this.errorOccured || !completed && !Boolean.getBoolean("resumeDownload")) {
                    if (!this.keepCacheOnError) {
                        this.cache.deleteTmp();
                        logger.debug(String.valueOf(this.cache.getCacheFileName()) + " deleted");
                    }
                    if (this.retrieveTitleTask != null) {
                        this.retrieveTitleTask.cancel(true);
                    }
                    break block16;
                }
                if (!completed) {
                    try {
                        String title;
                        if (this.retrieveTitleTask != null && (title = this.retrieveTitleTask.get()) != null) {
                            this.cache.setDescribe(title);
                            this.cache.setTmpDescribe(title);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("title retrieving failed: " + e.toString());
                    }
                    logger.info("suspended: " + this.cache.getCacheFileName());
                    break block16;
                }
                try {
                    String title;
                    if (this.retrieveTitleTask != null && (title = this.retrieveTitleTask.get()) != null) {
                        this.cache.setDescribe(title);
                    }
                }
                catch (Exception e) {
                    logger.warn("title retrieving failed: " + e.toString());
                }
                this.cache.store();
                try {
                    GenkidamaManager.getInstance().putNicoCache(this.cache.getId());
                }
                catch (Exception e) {
                    logger.error("Error Occurs:", e);
                }
                logger.info("cache completed: " + this.cache.getCacheFileName());
            }
            catch (IOException e) {
                logger.debug(e);
                logger.warn(e.toString());
            }
        }
    }
}

