/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.processor.HttpResponseHeader;
import dareka.processor.URLResource;
import dareka.processor.impl.NicoApiUtil;
import dareka.processor.impl.NicoIdInfoCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NicoCachingTitleRetriever
implements Callable<String> {
    public static Log logger = LogFactory.getLog(NicoCachingTitleRetriever.class);
    private String type;
    private String id;

    public NicoCachingTitleRetriever(String type, String id) {
        this.type = type;
        this.id = id;
    }

    @Override
    public String call() throws Exception {
        logger.debug("title retrieving start");
        String url = NicoApiUtil.getThumbURL(this.type, this.id);
        URLResource r = new URLResource(url);
        r.setFollowRedirects(true);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        r.transferTo(null, bout, null, null);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        new HttpResponseHeader(bin);
        String title = NicoApiUtil.getThumbTitle(bin);
        logger.debug("title retrieving end (" + title + ")");
        NicoIdInfoCache.getInstance().put(this.type, this.id, title);
        return title;
    }
}

