/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NicoIdInfoCache {
    public static Log logger = LogFactory.getLog(NicoIdInfoCache.class);
    private static final NicoIdInfoCache SINGLETON_INSTANCE = new NicoIdInfoCache();
    private static final int MAX_RECENT = 10;
    private ReferenceQueue<Entry> queue = new ReferenceQueue();
    private ConcurrentHashMap<String, EntryReference> id2title = new ConcurrentHashMap();
    private final LinkedList<Entry> recentEntry = new LinkedList();

    public static NicoIdInfoCache getInstance() {
        return SINGLETON_INSTANCE;
    }

    public Entry get(String id) {
        this.expunge();
        EntryReference entryRef = this.id2title.get(id);
        if (entryRef == null) {
            return null;
        }
        Entry entry = (Entry)entryRef.get();
        if (entry == null) {
            return null;
        }
        return entry;
    }

    public void put(String type, String id, String title) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("title must not be null");
        }
        Entry entry = new Entry(type, id, title);
        this.constructReference(id, entry);
    }

    public void putOnlyTypeAndId(String type, String id) {
        Entry existingEntry = this.get(id);
        if (existingEntry != null && existingEntry.isTitleValid()) {
            return;
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        Entry entry = new Entry(type, id);
        this.constructReference(id, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructReference(String id, Entry entry) {
        this.expunge();
        EntryReference entryRef = new EntryReference(entry, this.queue);
        this.id2title.put(id, entryRef);
        LinkedList<Entry> linkedList = this.recentEntry;
        synchronized (linkedList) {
            if (!this.recentEntry.remove(entry) && this.recentEntry.size() >= 10) {
                this.recentEntry.poll();
            }
            this.recentEntry.add(entry);
        }
    }

    public int size() {
        this.expunge();
        return this.id2title.size();
    }

    private void expunge() {
        EntryReference ref;
        while ((ref = (EntryReference)this.queue.poll()) != null) {
            String id = ref.getId();
            this.id2title.remove(id);
            logger.debug("title cache expunged: " + id);
        }
    }

    public static class Entry {
        private static final String INVALID_TITLE = new String("nicocache-unknown-title");
        private String type;
        private String id;
        private String title;

        Entry(String type, String id, String title) {
            this.type = type;
            this.id = id;
            this.title = title;
        }

        Entry(String type, String id) {
            this.type = type;
            this.id = id;
            this.title = INVALID_TITLE;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                Entry other = (Entry)obj;
                return this.type.equals(other.type) && this.id.equals(other.id) && this.title.equals(other.title);
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.id.hashCode() ^ this.title.hashCode();
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isTitleValid() {
            return this.title != INVALID_TITLE;
        }
    }

    static class EntryReference
    extends SoftReference<Entry> {
        private String id;

        EntryReference(Entry entry, ReferenceQueue<Entry> q) {
            super(entry, q);
            this.id = entry.getId();
        }

        String getId() {
            return this.id;
        }
    }
}

