/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.common.CloseUtil;
import dareka.processor.HttpResponseHeader;
import dareka.processor.HttpUtil;
import dareka.processor.TransferListener;
import dareka.processor.impl.NicoIdInfoCache;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NicoRecordingWatchListener
implements TransferListener {
    public static Log logger = LogFactory.getLog(NicoRecordingWatchListener.class);
    private static final int MAX_READ_SIZE = 32768;
    private static final Pattern VIDEO_ID_PATTERN = Pattern.compile("(?:video_id = |id:\\s*)'([a-z]{2})(\\d+)'");
    private static final Pattern TITLE_PATTERN = Pattern.compile("<h1[^>]*?><a [^>]*?>(.{1,1024}?)</");
    private ByteArrayOutputStream out = new ByteArrayOutputStream(32768);
    private String type;
    private String id;
    private String contentEncoding;

    public NicoRecordingWatchListener() {
        this(null, null);
    }

    public NicoRecordingWatchListener(String type, String id) {
        if (type != null && id != null) {
            this.type = type;
            this.id = id;
        }
    }

    @Override
    public void onResponseHeader(HttpResponseHeader responseHeader) {
        this.contentEncoding = responseHeader.getMessageHeader("Content-Encoding");
    }

    @Override
    public void onTransferBegin(OutputStream receiverOut) {
    }

    @Override
    public void onTransferring(byte[] buf, int length) {
        int remain = 32768 - this.out.size();
        if (remain <= 0) {
            return;
        }
        int recordingLen = remain > length ? length : remain;
        this.out.write(buf, 0, recordingLen);
    }

    @Override
    public void onTransferEnd(boolean completed) {
        String title;
        if (!completed) {
            return;
        }
        String page = this.getPage();
        if (this.type == null) {
            Matcher mId = VIDEO_ID_PATTERN.matcher(page);
            if (!mId.find()) {
                logger.warn("no video id found");
                return;
            }
            this.type = mId.group(1);
            this.id = mId.group(2);
        }
        if ((title = this.getTitleFromWatchPage(page)) == null) {
            logger.warn("no title found: " + this.type + this.id);
            return;
        }
        NicoIdInfoCache.getInstance().put(this.type, this.id, title);
        logger.debug("title recorded: " + this.type + this.id + " => " + title);
    }

    private String getPage() {
        StringBuilder pageBuf;
        block12: {
            pageBuf = new StringBuilder(this.out.size() * 4);
            InputStreamReader r = null;
            try {
                InputStream decodedIn = HttpUtil.getDecodedInputStream(this.out.toByteArray(), this.contentEncoding);
                r = new InputStreamReader(decodedIn, "UTF-8");
                try {
                    int ch;
                    while ((ch = r.read()) != -1) {
                        pageBuf.append((char)ch);
                    }
                }
                catch (EOFException e) {
                    logger.debug("partial content: " + e.toString());
                }
                catch (IOException e) {
                    logger.warn("content decoding error: " + e.toString());
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error Occurs:", e);
                CloseUtil.close(r);
                break block12;
            }
            catch (IOException e) {
                try {
                    logger.error("Error Occurs:", e);
                    break block12;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    CloseUtil.close(r);
                }
            }
            CloseUtil.close(r);
        }
        return pageBuf.toString();
    }

    String getTitleFromWatchPage(String page) {
        Matcher m = TITLE_PATTERN.matcher(page);
        if (!m.find()) {
            return null;
        }
        String title = m.group(1);
        return title;
    }
}

