/*
 * Decompiled with CFR 0.152.
 */
package orca.cod;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class Util {
    private long strip(long number) {
        return number & 0xFFFFFFL;
    }

    public static long IPToLong(String ipaddr) throws Exception {
        InetAddress in_addr = InetAddress.getByName(ipaddr);
        return Util.inetAddressToLong(in_addr);
    }

    public static long inetAddressToLong(InetAddress in_addr) {
        byte[] addr = in_addr.getAddress();
        long b1 = addr[0] << 24;
        long b2 = addr[1] << 16;
        long b3 = addr[2] << 8;
        long b4 = addr[3];
        long a1 = b1 & 0xFF000000L;
        long a2 = b2 & 0xFF0000L;
        long a3 = b3 & 0xFF00L;
        long a4 = b4 & 0xFFL;
        long ret = a1 | a2 | a3 | a4;
        assert (ret > 0L);
        return ret;
    }

    public static InetAddress longToInetAddress(long ipaddr) throws Exception {
        assert (ipaddr <= Long.MAX_VALUE);
        byte[] addr = new byte[]{(byte)((ipaddr & 0xFF000000L) >> 24), (byte)((ipaddr & 0xFF0000L) >> 16), (byte)((ipaddr & 0xFF00L) >> 8), (byte)(ipaddr & 0xFFL)};
        InetAddress ia = InetAddress.getByAddress(addr);
        return ia;
    }

    public static int netmaskToSize(String mask) throws Exception {
        long netmask = Util.IPToLong(mask);
        long size = 0xFFFFFFFFFFFFFFFFL & (netmask ^ 0xFFFFFFFFFFFFFFFFL);
        return (int)size;
    }

    public static boolean sameSubnet(InetAddress a, InetAddress b, InetAddress mask) throws Exception {
        long addrA = Util.inetAddressToLong(a);
        long addrB = Util.inetAddressToLong(b);
        long longMask = Util.inetAddressToLong(mask);
        return (addrA & longMask) == (addrB & longMask);
    }

    public static int netmaskToSize(InetAddress mask) {
        long netmask = Util.inetAddressToLong(mask);
        long result = netmask ^ 0xFFFFFFFFFFFFFFFFL;
        int size = (int)result + 1;
        return size;
    }

    public static long IPSubnetOffset(InetAddress ipaddr, InetAddress base, InetAddress mask) {
        long subnetBase = Util.inetAddressToLong(base);
        int size = Util.netmaskToSize(mask);
        long addr = Util.inetAddressToLong(ipaddr);
        assert (addr <= subnetBase + (long)size);
        return addr - subnetBase;
    }

    public static InetAddress subnetOffsetToIP(long num, InetAddress base) throws Exception {
        long result = Util.inetAddressToLong(base);
        InetAddress address = Util.longToInetAddress(result += num);
        return address;
    }

    public static String padInt(int orig_num, int pad_length) {
        StringBuffer padded = new StringBuffer();
        String zero = "0";
        double max = Math.pow(10.0, pad_length - 1);
        while ((double)orig_num < max && max > 0.0) {
            padded.append(zero);
            max /= 10.0;
        }
        padded.append(orig_num);
        return padded.toString();
    }

    public static String padLong(long orig_num, int pad_length) {
        StringBuffer padded = new StringBuffer();
        String zero = "0";
        double max = Math.pow(10.0, pad_length - 1);
        while ((double)orig_num < max && max > 0.0) {
            padded.append(zero);
            max /= 10.0;
        }
        padded.append(orig_num);
        return padded.toString();
    }

    public static String ipToString(InetAddress addr) {
        String ipaddr = addr.toString();
        if (ipaddr.startsWith("/")) {
            ipaddr = ipaddr.substring(1);
        }
        return ipaddr;
    }

    public static InetAddress stringToIP(String addr) throws Exception {
        StringTokenizer st = new StringTokenizer(addr, ".");
        int counter = 0;
        byte[] b = new byte[4];
        while (st.hasMoreTokens()) {
            if (counter > 3) {
                throw new Exception("Not correctly formatted IP");
            }
            String s = st.nextToken();
            b[counter] = new Integer(Integer.parseInt(s)).byteValue();
            ++counter;
        }
        InetAddress ip = InetAddress.getByAddress(b);
        return ip;
    }

    public static String byteToPaddedHex(byte b) {
        int i = b & 0xFF;
        String s = Integer.toHexString(i);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static void main(String[] argv) {
        System.out.println(Util.padInt(3, 3));
        System.out.println(Util.padInt(1, 1));
        System.out.println(Util.padInt(10, 5));
    }

    public static Properties combineProps(Properties base, Properties add) {
        Enumeration<?> f = add.propertyNames();
        while (f.hasMoreElements()) {
            String arg = (String)f.nextElement();
            String value = add.getProperty(arg);
            if (base.getProperty(arg) != null) {
                System.out.println("Util.combineProps.: overwriting on key (" + arg + ") value(" + base.getProperty(arg) + ") => (" + value + ")");
            }
            base.setProperty(arg, value);
        }
        return base;
    }
}

