/*
 * Decompiled with CFR 0.152.
 */
package org.positrium.chikarawo;

import com.dokukino.genkidama.VersionInfo;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.positrium.chikarawo.LogWindow;
import org.positrium.chikarawo.MyTrayIcon;

public class Chikarawo {
    public static Log logger = LogFactory.getLog(Chikarawo.class);
    private String version = VersionInfo.getFullVersion();
    private SystemTray tray = SystemTray.getSystemTray();
    private MyTrayIcon normalTrayIcon;

    public Chikarawo() {
        PopupMenu popup = new PopupMenu();
        MenuItem dashboard = new MenuItem("dashboard");
        dashboard.addActionListener(this.getDashboardAction());
        popup.add(dashboard);
        MenuItem logWindow = new MenuItem("log window");
        logWindow.addActionListener(this.getLogWindowAction());
        popup.add(logWindow);
        popup.addSeparator();
        MenuItem quit = new MenuItem("quit");
        quit.addActionListener(this.getQuitAction());
        popup.add(quit);
        try {
            this.normalTrayIcon = new MyTrayIcon(this.version, popup);
        }
        catch (FileNotFoundException e) {
            logger.fatal(e);
        }
        LogWindow.getInstance().show();
    }

    private ActionListener getLogWindowAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogWindow.getInstance().show();
            }
        };
    }

    private ActionListener getDashboardAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://genkidama.us/"));
                }
                catch (IOException e1) {
                    logger.error("Error Occurs:", e1);
                }
                catch (URISyntaxException e1) {
                    logger.error("Error Occurs:", e1);
                }
            }
        };
    }

    public void showTooltip(String message) {
        this.tray.getTrayIcons()[0].displayMessage(this.version, message, TrayIcon.MessageType.INFO);
    }

    public void openTray() {
        if (SystemTray.isSupported()) {
            try {
                this.tray.add(this.normalTrayIcon);
            }
            catch (AWTException e1) {
                logger.error("Error Occurs:", e1);
            }
        } else {
            logger.warn("System Tray not supported on your Environment");
        }
    }

    private ActionListener getQuitAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
    }
}

