/*
 * Decompiled with CFR 0.152.
 */
package org.positrium.chikarawo;

import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.FileNotFoundException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.positrium.chikarawo.FileResource;

public class LogWindow {
    private static final int MAX_LINE = 1024;
    private static LogWindow instance = new LogWindow();
    private JFrame frame;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JViewport viewpoint;
    private int lastScrollHeight = -1;
    private int lastViewHeight = -1;
    private boolean changedFlg = false;
    private StringBuffer buffer = new StringBuffer();

    private LogWindow() {
        this.frame = new JFrame("Log window");
        this.frame.setBounds(16, 16, 640, 480);
        try {
            Image icon = new ImageIcon(new FileResource("resource/genkidama_initial.png").toURL()).getImage();
            this.frame.setIconImage(icon);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Font font = new Font("Monospaced", 0, 12);
        this.textArea = new JTextArea();
        this.textArea.setFont(font);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.viewpoint = this.scrollPane.getViewport();
        this.viewpoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Rectangle rect = LogWindow.this.viewpoint.getViewRect();
                if (LogWindow.this.lastScrollHeight == LogWindow.this.textArea.getHeight() && LogWindow.this.lastViewHeight == rect.height && !LogWindow.this.changedFlg) {
                    return;
                }
                if (LogWindow.this.lastScrollHeight - LogWindow.this.lastViewHeight == rect.y) {
                    rect.setLocation(rect.x, LogWindow.this.textArea.getHeight() - rect.height);
                    LogWindow.this.textArea.scrollRectToVisible(rect);
                }
                LogWindow.this.lastScrollHeight = LogWindow.this.textArea.getHeight();
                LogWindow.this.lastViewHeight = rect.height;
                LogWindow.this.changedFlg = false;
            }
        });
        this.frame.add(this.scrollPane);
        new LogAppender().start();
    }

    public static LogWindow getInstance() {
        return instance;
    }

    public void show() {
        this.frame.setVisible(true);
        this.frame.setState(0);
    }

    public void close() {
        instance = null;
        this.frame.dispose();
        this.frame = null;
    }

    public Rectangle getBounds() {
        return this.frame.getBounds();
    }

    public void setBounds(Rectangle r) {
        this.frame.setBounds(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String str) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.append(str);
            this.buffer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(byte[] b) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.append(b);
            this.buffer.notify();
        }
    }

    public void append(byte[] b, int off, int len) {
        this.append(new String(b, off, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(int b) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.append(b);
            this.buffer.notify();
        }
    }

    private class LogAppender
    extends Thread {
        private LogAppender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                StringBuffer stringBuffer = LogWindow.this.buffer;
                synchronized (stringBuffer) {
                    try {
                        LogWindow.this.buffer.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    LogWindow.this.textArea.append(LogWindow.this.buffer.toString());
                    LogWindow.this.buffer.delete(0, LogWindow.this.buffer.length());
                }
                if (LogWindow.this.textArea.getLineCount() > 1024) {
                    try {
                        int offset = LogWindow.this.textArea.getLineEndOffset(LogWindow.this.textArea.getLineCount() - 1024 - 1);
                        LogWindow.this.textArea.getDocument().remove(0, offset);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                LogWindow.this.changedFlg = true;
            }
        }
    }
}

