/*
 * Decompiled with CFR 0.152.
 */
package org.positrium.waket.proxy;

import dareka.processor.HttpRequestHeader;
import dareka.processor.Processor;
import dareka.processor.Resource;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaketProcessor
implements Processor {
    public static Log logger = LogFactory.getLog(WaketProcessor.class);
    private static final String[] SUPPORTED_METHODS = new String[]{"GET", "POST", "HEAD"};
    private static final Pattern WAKET_URL_PATTERN = Pattern.compile("^http://genkidama\\.us/local/(.+)");

    @Override
    public String[] getSupportedMethods() {
        return SUPPORTED_METHODS;
    }

    @Override
    public Pattern getSupportedURLAsPattern() {
        return WAKET_URL_PATTERN;
    }

    @Override
    public String getSupportedURLAsString() {
        return null;
    }

    @Override
    public Resource onRequest(HttpRequestHeader requestHeader) throws IOException {
        logger.debug("original: " + requestHeader.getURI());
        Matcher m = WAKET_URL_PATTERN.matcher(requestHeader.getURI());
        String url = "http://localhost:" + Integer.getInteger("dhtDataPort") + "/";
        if (m.matches()) {
            url = String.valueOf(url) + m.group(1);
            logger.debug("replaced: " + url);
        }
        Resource r = Resource.get(Resource.Type.URL, url);
        return r;
    }
}

