/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.routing.RoutingException;
import ow.util.HighLevelService;

public interface DHT<V extends Serializable>
extends HighLevelService {
    public void clearDHTState();

    public Set<ValueInfo<V>> put(ID var1, V var2) throws Exception;

    public Set<ValueInfo<V>> put(ID var1, V[] var2) throws Exception;

    public Set<ValueInfo<V>>[] put(PutRequest<V>[] var1) throws Exception;

    public Set<ValueInfo<V>> get(ID var1) throws RoutingException;

    public Set<ValueInfo<V>>[] get(ID[] var1);

    public Set<ValueInfo<V>> remove(ID var1, V[] var2, ByteArray var3) throws RoutingException;

    public Set<ValueInfo<V>> remove(ID var1, ID[] var2, ByteArray var3) throws RoutingException;

    public Set<ValueInfo<V>> remove(ID var1, ByteArray var2) throws RoutingException;

    public Set<ValueInfo<V>>[] remove(RemoveRequest<V>[] var1, ByteArray var2);

    public ByteArray setHashedSecretForPut(ByteArray var1);

    public int setTTLForPut(int var1);

    public Set<ID> getLocalKeys();

    public Set<ValueInfo<V>> getLocalValues(ID var1);

    public Set<ID> getGlobalKeys();

    public Set<ValueInfo<V>> getGlobalValues(ID var1);

    @Override
    public DHTConfiguration getConfiguration();

    public static class PutRequest<V>
    implements Serializable {
        private final ID key;
        private final V[] values;

        public PutRequest(ID key, V[] values) {
            this.key = key;
            this.values = values;
        }

        public ID getKey() {
            return this.key;
        }

        public V[] getValues() {
            return this.values;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ key: ").append(this.key.toString());
            if (this.values != null) {
                sb.append(", value:");
                V[] VArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    V v = VArray[n2];
                    sb.append(" ").append(v);
                    ++n2;
                }
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static final class RemoveRequest<V>
    extends PutRequest<V> {
        private final ID[] valueHash;

        public RemoveRequest(ID key, V[] values) {
            super(key, values);
            this.valueHash = null;
        }

        public RemoveRequest(ID key, ID[] valueHash) {
            super(key, null);
            this.valueHash = valueHash;
        }

        public RemoveRequest(ID key) {
            super(key, null);
            this.valueHash = null;
        }

        public ID[] getValueHash() {
            return this.valueHash;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ key: ").append(((PutRequest)this).key.toString());
            if (((PutRequest)this).values != null) {
                sb.append(", value:");
                Object[] objectArray = ((PutRequest)this).values;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    sb.append(" ").append(v);
                    ++n2;
                }
            } else if (this.valueHash != null) {
                sb.append(", vlaueHash:");
                ID[] iDArray = this.valueHash;
                int n = this.valueHash.length;
                int n3 = 0;
                while (n3 < n) {
                    ID vh = iDArray[n3];
                    sb.append(" ").append(vh.toString());
                    ++n3;
                }
            }
            sb.append(" }");
            return sb.toString();
        }
    }
}

