/*
 * Decompiled with CFR 0.152.
 */
package ow.dht.impl;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.directory.DirectoryConfiguration;
import ow.directory.DirectoryFactory;
import ow.directory.DirectoryProvider;
import ow.directory.MultiValueDirectory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessagingAddress;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;

public final class CHTImpl<V extends Serializable>
implements DHT<V> {
    public static Log logger = LogFactory.getLog(CHTImpl.class);
    private static final String GLOBAL_DB_NAME = "global";
    private DHTConfiguration config;
    private RoutingAlgorithmConfiguration algoConfig;
    private IDAddressPair selfIDAddressPair;
    private MultiValueDirectory<ID, ValueInfo<V>> globalDir;
    private ByteArray hashedSecretForPut;
    private int ttlForPut;
    private ID[] lastKeys = new ID[1];
    private RoutingResult[] lastRoutingResults;

    public CHTImpl(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        this.init(config, selfID);
    }

    public CHTImpl(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        this.init(config, routingSvc != null ? routingSvc.getSelfIDAddressPair().getID() : null);
    }

    private void init(DHTConfiguration config, ID selfID) throws Exception {
        this.config = config;
        this.hashedSecretForPut = null;
        this.ttlForPut = config.getDefaultTTL();
        this.algoConfig = new RoutingAlgorithmConfiguration();
        this.selfIDAddressPair = selfID != null ? IDAddressPair.getIDAddressPair(selfID, null) : IDAddressPair.getIDAddressPair(20, null);
        File workingDirFile = new File(config.getWorkingDirectory());
        workingDirFile.mkdirs();
        DirectoryProvider dirProvider = DirectoryFactory.getProvider(config.getDirectoryType());
        DirectoryConfiguration dirConfig = DirectoryConfiguration.getDefaultConfiguration();
        if (config.getDoExpire()) {
            dirConfig.setExpirationTime(config.getDefaultTTL());
        } else {
            dirConfig.setExpirationTime(-1);
        }
        this.globalDir = dirProvider.openMultiValueDirectory(ID.class, config.getValueClass(), config.getWorkingDirectory(), GLOBAL_DB_NAME, dirConfig);
        RoutingHop[] route = new RoutingHop[]{RoutingHop.newInstance(this.selfIDAddressPair)};
        IDAddressPair[] roots = new IDAddressPair[]{this.selfIDAddressPair};
        this.lastRoutingResults = new RoutingResult[1];
        this.lastRoutingResults[0] = new RoutingResult(route, roots);
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort, int defaultPort) throws UnknownHostException {
        return this.joinOverlay();
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort) throws UnknownHostException {
        return this.joinOverlay();
    }

    private MessagingAddress joinOverlay() {
        this.lastKeys[0] = this.selfIDAddressPair.getID();
        return null;
    }

    @Override
    public void clearRoutingTable() {
        this.lastKeys[0] = null;
    }

    @Override
    public void clearDHTState() {
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V value) {
        Serializable[] values = (Serializable[])new Object[1];
        values[0] = value;
        return this.put(key, (V)values);
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V[] values) {
        Set<ValueInfo<V>> existedValue = null;
        try {
            existedValue = this.globalDir.get(key);
            V[] VArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                V v = VArray[n2];
                this.globalDir.put(key, new ValueInfo<V>(v, this.ttlForPut, this.hashedSecretForPut), this.ttlForPut);
                ++n2;
            }
        }
        catch (Exception e) {
            logger.warn("An Exception thrown by Directory#put().", e);
        }
        this.lastKeys[0] = key;
        return existedValue;
    }

    @Override
    public Set<ValueInfo<V>>[] put(DHT.PutRequest<V>[] requests) {
        Set[] results = new Set[requests.length];
        int i = 0;
        while (i < requests.length) {
            DHT.PutRequest<V> req = requests[i];
            results[i] = this.put(req.getKey(), (V)((Serializable[])req.getValues()));
            if (results[i] == null) {
                results[i] = new HashSet();
            }
            ++i;
        }
        return results;
    }

    @Override
    public Set<ValueInfo<V>> get(ID key) {
        Set<ValueInfo<V>> results = null;
        try {
            results = this.globalDir.get(key);
        }
        catch (Exception e) {
            logger.warn("An Exception thrown during getting.", e);
        }
        this.lastKeys[0] = key;
        return results;
    }

    @Override
    public Set<ValueInfo<V>>[] get(ID[] keys) {
        Set[] results = new Set[keys.length];
        int i = 0;
        while (i < keys.length) {
            results[i] = this.get(keys[i]);
            if (results[i] == null) {
                results[i] = new HashSet();
            }
            ++i;
        }
        return results;
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, V[] values, ByteArray hashedSecret) {
        ID[] valueHash = new ID[values.length];
        int j = 0;
        while (j < values.length) {
            try {
                valueHash[j] = ID.getSHA1BasedID(values[j].toString().getBytes(this.config.getValueEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++j;
        }
        return this.removeInternally(key, valueHash, hashedSecret);
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, ID[] valueHash, ByteArray hashedSecret) {
        return this.removeInternally(key, valueHash, hashedSecret);
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, ByteArray hashedSecret) {
        return this.removeInternally(key, null, hashedSecret);
    }

    @Override
    public Set<ValueInfo<V>>[] remove(DHT.RemoveRequest<V>[] requests, ByteArray hashedSecret) {
        Set[] results = new Set[requests.length];
        int i = 0;
        while (i < requests.length) {
            ID[] valueHash;
            DHT.RemoveRequest<V> req = requests[i];
            if (req.getValues() != null) {
                Serializable[] values = (Serializable[])req.getValues();
                valueHash = new ID[values.length];
                int j = 0;
                while (j < values.length) {
                    try {
                        valueHash[j] = ID.getSHA1BasedID(values[j].toString().getBytes(this.config.getValueEncoding()));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    ++j;
                }
            } else {
                valueHash = req.getValueHash();
            }
            results[i] = this.removeInternally(req.getKey(), valueHash, hashedSecret);
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ValueInfo<V>> removeInternally(ID key, ID[] valueHash, ByteArray hashedSecret) {
        HashSet<ValueInfo<V>> ret = new HashSet<ValueInfo<V>>();
        CHTImpl cHTImpl = this;
        synchronized (cHTImpl) {
            block15: {
                try {
                    Set<ValueInfo<V>> existedValues = this.globalDir.get(key);
                    if (existedValues == null) break block15;
                    ValueInfo[] existedValueArray = new ValueInfo[existedValues.size()];
                    existedValues.toArray(existedValueArray);
                    ValueInfo[] valueInfoArray = existedValueArray;
                    int n = existedValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ValueInfo v = valueInfoArray[n2];
                        ID h = ID.getSHA1BasedID(v.getValue().toString().getBytes(this.config.getValueEncoding()));
                        if (hashedSecret.equals(v.getHashedSecret())) {
                            boolean remove = false;
                            if (valueHash == null) {
                                remove = true;
                            } else {
                                ID[] iDArray = valueHash;
                                int n3 = valueHash.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ID valH = iDArray[n4];
                                    if (h.equals(valH)) {
                                        remove = true;
                                    }
                                    ++n4;
                                }
                            }
                            if (remove) {
                                MultiValueDirectory<ID, ValueInfo<V>> multiValueDirectory = this.globalDir;
                                synchronized (multiValueDirectory) {
                                    this.globalDir.remove(key, v);
                                }
                                ret.add(v);
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    logger.warn("An Exception thrown during getting.", e);
                }
            }
        }
        this.lastKeys[0] = key;
        return ret;
    }

    @Override
    public ByteArray setHashedSecretForPut(ByteArray hashedSecret) {
        ByteArray old = this.hashedSecretForPut;
        this.hashedSecretForPut = hashedSecret;
        return old;
    }

    @Override
    public int setTTLForPut(int ttl) {
        int old = this.ttlForPut;
        this.ttlForPut = ttl;
        return old;
    }

    @Override
    public void stop() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public Set<ID> getLocalKeys() {
        return this.globalDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getLocalValues(ID key) {
        return this.getValuesInternally(key);
    }

    @Override
    public Set<ID> getGlobalKeys() {
        return this.globalDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getGlobalValues(ID key) {
        return this.getValuesInternally(key);
    }

    private Set<ValueInfo<V>> getValuesInternally(ID key) {
        Set<ValueInfo<V>> ret = null;
        try {
            ret = this.globalDir.get(key);
        }
        catch (Exception e) {
            logger.warn("An Exception thrown when retrieve from the globalDir.", e);
        }
        return ret;
    }

    @Override
    public RoutingService getRoutingService() {
        return null;
    }

    @Override
    public DHTConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration() {
        return this.algoConfig;
    }

    @Override
    public IDAddressPair getSelfIDAddressPair() {
        return this.selfIDAddressPair;
    }

    @Override
    public void setStatCollectorAddress(String host, int port) throws UnknownHostException {
    }

    @Override
    public ID[] getLastKeys() {
        return this.lastKeys;
    }

    @Override
    public RoutingResult[] getLastRoutingResults() {
        return this.lastRoutingResults;
    }

    @Override
    public String getRoutingTableString(int verboseLevel) {
        return "";
    }
}

