/*
 * Decompiled with CFR 0.152.
 */
package ow.directory;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.directory.DirectoryProvider;
import ow.directory.berkeleydb.BerkeleyDBProvider;
import ow.directory.inmemory.PersistentMapProvider;
import ow.directory.inmemory.VolatileMapProvider;

public class DirectoryFactory {
    public static Log logger = LogFactory.getLog(DirectoryFactory.class);
    private static final Class[] PROVIDERS = new Class[]{VolatileMapProvider.class, PersistentMapProvider.class, BerkeleyDBProvider.class};
    private static final HashMap<String, DirectoryProvider> providerTable = new HashMap();

    static {
        Class[] classArray = PROVIDERS;
        int n = PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Object o;
                Class clazz = classArray[n2];
                try {
                    o = clazz.newInstance();
                }
                catch (Exception e) {
                    logger.warn("Could not instantiate an object of the class: " + clazz, e);
                    break block4;
                }
                if (o instanceof DirectoryProvider) {
                    DirectoryProvider provider = (DirectoryProvider)o;
                    providerTable.put(provider.getName(), provider);
                }
            }
            ++n2;
        }
    }

    public static DirectoryProvider getProvider(String providerName) throws NoSuchProviderException {
        DirectoryProvider provider = providerTable.get(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("No such provider: " + providerName);
        }
        return provider;
    }
}

