/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.berkeleydb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ow.directory.DirectoryConfiguration;
import ow.directory.DirectoryProvider;
import ow.directory.MultiValueDirectory;
import ow.directory.SingleValueDirectory;
import ow.directory.berkeleydb.MultiValueJEDirectory;
import ow.directory.berkeleydb.SingleValueJEDirectory;

public class BerkeleyDBProvider
extends DirectoryProvider {
    private static final String NAME = "BerkeleyDB";
    protected static final boolean ALLOW_CREATE = true;
    private final Map<File, Environment> envTable = Collections.synchronizedMap(new HashMap());
    private EnvironmentConfig envConfig = null;
    private boolean initialized = false;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected <K, V> SingleValueDirectory<K, V> provideSingleValueDirectory(Class typeK, Class typeV, String workingDir, String dbName, DirectoryConfiguration config) throws Exception {
        this.init();
        Environment env = this.getEnvironment(new File(workingDir));
        return new SingleValueJEDirectory(typeK, typeV, env, dbName);
    }

    @Override
    protected <K, V> MultiValueDirectory<K, V> provideMultiValueDirectory(Class typeK, Class typeV, String workingDir, String dbName, DirectoryConfiguration config) throws Exception {
        this.init();
        Environment env = this.getEnvironment(new File(workingDir));
        return new MultiValueJEDirectory(typeK, typeV, env, dbName);
    }

    private void init() {
        if (!this.initialized) {
            this.envConfig = new EnvironmentConfig();
            this.envConfig.setTransactional(true);
            this.envConfig.setAllowCreate(true);
            this.initialized = true;
        }
    }

    @Override
    public void removeDirectory(String dir, String dbName) throws Exception {
        Environment env = this.getEnvironment(new File(dir));
        Transaction txn = env.beginTransaction(null, null);
        env.removeDatabase(txn, dbName);
        env.removeDatabase(txn, String.valueOf(dbName) + ".catalog");
        txn.commit();
    }

    private Environment getEnvironment(File dir) throws DatabaseException {
        Environment env = this.envTable.get(dir);
        if (env == null) {
            env = new Environment(dir, this.envConfig);
            this.envTable.put(dir, env);
        }
        return env;
    }
}

