/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.berkeleydb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.directory.MultiValueDirectory;
import ow.directory.berkeleydb.AbstractJEDirectory;

public class MultiValueJEDirectory<K, V>
extends AbstractJEDirectory<K, V>
implements MultiValueDirectory<K, V> {
    public static Log logger = LogFactory.getLog(MultiValueJEDirectory.class);

    protected MultiValueJEDirectory(Class typeK, Class typeV, Environment env, String dbName) throws Exception {
        super(typeK, typeV, env, dbName, true);
    }

    @Override
    public Set<V> get(K key) throws DatabaseException {
        return this.getAndRemove(key, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V put(K key, V value) throws Exception {
        block2: {
            keyEntry = new DatabaseEntry();
            dataEntry = new DatabaseEntry();
            this.keyBinding.objectToEntry(key, keyEntry);
            this.dataBinding.objectToEntry(value, dataEntry);
            ret = null;
            txn = this.env.beginTransaction(null, null);
            cursor = this.db.openCursor(txn, null);
            if (cursor.getSearchKey(keyEntry, dataEntry, LockMode.DEFAULT) != OperationStatus.SUCCESS) break block2;
            v = this.dataBinding.entryToObject(dataEntry);
            if (!value.equals(v)) ** GOTO lbl21
            ret = (V)v;
            cursor.delete();
            break block2;
lbl-1000:
            // 1 sources

            {
                v = this.dataBinding.entryToObject(dataEntry);
                if (!value.equals(v)) continue;
                ret = (V)v;
                cursor.delete();
                break;
lbl21:
                // 2 sources

                ** while (cursor.getNextDup((DatabaseEntry)keyEntry, (DatabaseEntry)dataEntry, (LockMode)LockMode.DEFAULT) == OperationStatus.SUCCESS)
            }
        }
        this.keyBinding.objectToEntry(key, keyEntry);
        this.dataBinding.objectToEntry(value, dataEntry);
        if (cursor.put(keyEntry, dataEntry) != OperationStatus.SUCCESS) {
            msg = "Could not put: " + key + ", " + value;
            MultiValueJEDirectory.logger.warn(msg);
            throw new DatabaseException(msg);
        }
        cursor.close();
        txn.commit();
        return ret;
    }

    @Override
    public V put(K key, V value, int ttl) throws Exception {
        return this.put(key, value);
    }

    @Override
    public Set<V> remove(K key) throws DatabaseException {
        return this.getAndRemove(key, true);
    }

    @Override
    public V remove(K key, V value) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry foundEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        V ret = null;
        Transaction txn = this.env.beginTransaction(null, null);
        Cursor cursor = this.db.openCursor(txn, null);
        if (cursor.getSearchKey(keyEntry, foundEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            do {
                Object v;
                if (!value.equals(v = this.dataBinding.entryToObject(foundEntry))) continue;
                ret = (V)v;
                cursor.delete();
                break;
            } while (cursor.getNextDup(keyEntry, foundEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS);
        }
        cursor.close();
        txn.commit();
        return ret;
    }

    private Set<V> getAndRemove(K key, boolean remove) throws DatabaseException {
        DatabaseEntry searchKey = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, searchKey);
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        Transaction txn = this.env.beginTransaction(null, null);
        Cursor cursor = this.db.openCursor(txn, null);
        HashSet s = null;
        if (cursor.getSearchKey(searchKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            s = new HashSet();
            s.add(this.dataBinding.entryToObject(foundData));
            while (cursor.getNextDup(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                s.add(this.dataBinding.entryToObject(foundData));
            }
        }
        if (remove) {
            this.db.delete(txn, searchKey);
        }
        cursor.close();
        txn.commit();
        return s;
    }
}

