/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.inmemory;

import java.io.File;
import ow.directory.DirectoryConfiguration;
import ow.directory.DirectoryProvider;
import ow.directory.MultiValueDirectory;
import ow.directory.SingleValueDirectory;
import ow.directory.inmemory.MultipleValueHashDirectory;
import ow.directory.inmemory.SingleValueHashDirectory;

public final class PersistentMapProvider
extends DirectoryProvider {
    private static final String NAME = "PersistentMap";
    private static final long SYNC_INTERVAL = 3000L;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected <K, V> SingleValueDirectory<K, V> provideSingleValueDirectory(Class typeK, Class typeV, String dir, String dbName, DirectoryConfiguration config) throws Exception {
        return new SingleValueHashDirectory(typeK, typeV, dir, dbName, PersistentMapProvider.getBackupFilename(dbName), config, 3000L);
    }

    @Override
    protected <K, V> MultiValueDirectory<K, V> provideMultiValueDirectory(Class typeK, Class typeV, String dir, String dbName, DirectoryConfiguration config) throws Exception {
        return new MultipleValueHashDirectory(typeK, typeV, dir, dbName, PersistentMapProvider.getBackupFilename(dbName), config, 3000L);
    }

    @Override
    public void removeDirectory(String dir, String dbName) throws Exception {
        File dbFile = new File(String.valueOf(dir) + dbName);
        File backupFile = new File(String.valueOf(dir) + PersistentMapProvider.getBackupFilename(dbName) + ".old");
        dbFile.delete();
        backupFile.delete();
    }

    private static String getBackupFilename(String name) {
        return String.valueOf(name) + ".old";
    }
}

