/*
 * Decompiled with CFR 0.152.
 */
package ow.id.comparator;

import java.math.BigInteger;
import java.util.Comparator;
import ow.id.ID;
import ow.id.IDAddressPair;

public final class ClockwiseTowardTargetIDAddrComparator
implements Comparator<IDAddressPair> {
    private BigInteger targetIDInteger;
    private final BigInteger ID_SPACE_SIZE;

    public ClockwiseTowardTargetIDAddrComparator(int idSizeInBit, ID targetID) {
        this.targetIDInteger = targetID.toBigInteger();
        this.ID_SPACE_SIZE = BigInteger.ONE.shiftLeft(idSizeInBit);
    }

    @Override
    public int compare(IDAddressPair p1, IDAddressPair p2) {
        BigInteger dist2;
        BigInteger dist1 = this.targetIDInteger.subtract(p1.getID().toBigInteger());
        if (dist1.compareTo(BigInteger.ZERO) < 0) {
            dist1 = dist1.add(this.ID_SPACE_SIZE);
        }
        if ((dist2 = this.targetIDInteger.subtract(p2.getID().toBigInteger())).compareTo(BigInteger.ZERO) < 0) {
            dist2 = dist2.add(this.ID_SPACE_SIZE);
        }
        return dist1.compareTo(dist2);
    }
}

