/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.net.Inet4Address;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ow.ipmulticast.Filter;
import ow.ipmulticast.FilterMode;
import ow.ipmulticast.Group;
import ow.ipmulticast.Host;
import ow.ipmulticast.IGMP;
import ow.ipmulticast.VirtualInterface;

public final class GroupSet {
    private Map<Inet4Address, Group> groupMap = new HashMap<Inet4Address, Group>();
    private final VirtualInterface vif;

    GroupSet(VirtualInterface vif) {
        this.vif = vif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(Inet4Address address) {
        Group group = null;
        GroupSet groupSet = this;
        synchronized (groupSet) {
            group = this.groupMap.get(address);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group registerGroup(Inet4Address groupAddress) {
        Group group = null;
        GroupSet groupSet = this;
        synchronized (groupSet) {
            group = this.groupMap.get(groupAddress);
            if (group == null) {
                group = new Group(groupAddress, this.vif);
                this.groupMap.put(groupAddress, group);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Group> unregisterHost(Inet4Address groupAddress, Inet4Address hostAddress) {
        Group group = null;
        HashSet<Group> removedGroupSet = new HashSet<Group>();
        GroupSet groupSet = this;
        synchronized (groupSet) {
            group = this.groupMap.get(groupAddress);
            if (group == null) {
                return removedGroupSet;
            }
            group.unregisterHost(hostAddress);
            if (group.numOfHosts() <= 0) {
                this.groupMap.remove(groupAddress);
                removedGroupSet.add(group);
            }
        }
        return removedGroupSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getGroups() {
        GroupSet groupSet = this;
        synchronized (groupSet) {
            return this.groupMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLowestIGMPVersion() {
        int lowestVer = IGMP.DEFAULT_IGMP_VERSION;
        GroupSet groupSet = this;
        synchronized (groupSet) {
            for (Map.Entry<Inet4Address, Group> entry : this.groupMap.entrySet()) {
                int ver = entry.getValue().getLowestIGMPVersion();
                if (ver >= lowestVer) continue;
                lowestVer = ver;
            }
        }
        return lowestVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() {
        Filter filter;
        boolean excludeExists = false;
        boolean includeExists = false;
        GroupSet groupSet = this;
        synchronized (groupSet) {
            for (Group group : this.groupMap.values()) {
                for (Host host : group.getAllHost()) {
                    FilterMode filterMode = host.getFilterMode();
                    if (filterMode == FilterMode.EXCLUDE) {
                        excludeExists = true;
                        continue;
                    }
                    includeExists = true;
                }
            }
            FilterMode m = includeExists && !excludeExists ? FilterMode.INCLUDE : FilterMode.EXCLUDE;
            filter = new Filter(m);
            HashSet<Inet4Address> sourceSet = new HashSet<Inet4Address>();
            if (m == FilterMode.EXCLUDE) {
                Set<Inet4Address> set;
                Set<Inet4Address> s;
                for (Group group : this.groupMap.values()) {
                    for (Host host : group.getAllHost()) {
                        if (host.getFilterMode() != FilterMode.EXCLUDE) continue;
                        set = s = host.getSourceSet();
                        synchronized (set) {
                            sourceSet.addAll(s);
                        }
                    }
                }
                for (Group group : this.groupMap.values()) {
                    for (Host host : group.getAllHost()) {
                        if (host.getFilterMode() != FilterMode.INCLUDE) continue;
                        set = s = host.getSourceSet();
                        synchronized (set) {
                            sourceSet.removeAll(s);
                        }
                    }
                }
            } else {
                for (Group group : this.groupMap.values()) {
                    for (Host host : group.getAllHost()) {
                        Set<Inet4Address> s;
                        Set<Inet4Address> set = s = host.getSourceSet();
                        synchronized (set) {
                            sourceSet.addAll(s);
                        }
                    }
                }
            }
            filter.setSourceSet(sourceSet);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Group> expire(long expiration) {
        HashSet<Group> removedGroupSet = new HashSet<Group>();
        boolean changed = false;
        GroupSet groupSet = this;
        synchronized (groupSet) {
            for (Inet4Address address : this.groupMap.keySet()) {
                Group group = this.groupMap.get(address);
                if (group.expire(expiration)) {
                    changed = true;
                }
                if (group.numOfHosts() > 0) continue;
                removedGroupSet.add(group);
            }
            for (Group g : removedGroupSet) {
                this.groupMap.remove(g.getGroupAddress());
            }
        }
        return removedGroupSet;
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("groups [");
        for (Group g : this.groupMap.values()) {
            sb.append("\n");
            sb.append(indent);
            sb.append(g.toString("  "));
        }
        sb.append("\n");
        sb.append(indent);
        sb.append("]");
        return sb.toString();
    }
}

