/*
 * Decompiled with CFR 0.152.
 */
package ow.mcast.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.Mcast;
import ow.mcast.McastCallback;
import ow.mcast.McastConfiguration;
import ow.mcast.SpanningTreeChangedCallback;
import ow.mcast.impl.GroupSet;
import ow.mcast.impl.McastMessageFactory;
import ow.mcast.impl.NeighborTable;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.Signature;
import ow.messaging.Tag;
import ow.routing.CallbackOnNodeFailure;
import ow.routing.CallbackOnRoute;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmFactory;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingException;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceFactory;
import ow.routing.RoutingServiceProvider;
import ow.util.ExpiringMap;
import ow.util.ExpiringSet;

public final class McastImpl
implements Mcast {
    public static Log logger = LogFactory.getLog(McastImpl.class);
    private Message ackConnectMessage;
    private Message nackConnectMessage;
    private McastConfiguration config;
    private RoutingAlgorithmConfiguration algoConfig;
    private MessagingProvider msgProvider;
    private RoutingService routingSvc;
    private MessageReceiver receiver;
    private MessageSender sender;
    private boolean suspended = false;
    private NeighborTable neighborTable;
    protected GroupSet joinedGroupSet;
    private ExpiringSet<ID> connectRefuseGroupSet;
    private ExpiringMap<ID, MessagingAddress> connectProhibitedNeighborMap;
    private Thread refreshingThread = null;
    private Thread expiringThread = null;
    private MessagingAddress statCollectorAddress;
    List<SpanningTreeChangedCallback> spanningTreeChangedCallbacks = new ArrayList<SpanningTreeChangedCallback>(1);
    List<McastCallback> multicastCallbacks = new ArrayList<McastCallback>(1);
    private ID[] lastKeys = new ID[1];
    private RoutingResult[] lastRoutingResults = new RoutingResult[1];

    public McastImpl(McastConfiguration config, ID selfID) throws Exception {
        this(Signature.getAllAcceptingApplicationID(), Signature.getAllAcceptingApplicationVersion(), config, selfID);
    }

    public McastImpl(short applicationID, short applicationVersion, McastConfiguration config, ID selfID) throws Exception {
        byte[] messageSignature = Signature.getSignature(RoutingServiceFactory.getRoutingStyleID(config.getRoutingStyle()), RoutingAlgorithmFactory.getAlgorithmID(config.getRoutingAlgorithm()), applicationID, applicationVersion);
        this.msgProvider = MessagingFactory.getProvider(config.getMessagingTransport(), messageSignature);
        if (config.getSelfAddress() != null) {
            this.msgProvider.setSelfAddress(config.getSelfAddress());
        }
        MessagingConfiguration msgConfig = this.msgProvider.getDefaultConfiguration();
        msgConfig.setDoUPnPNATTraversal(config.getDoUPnPNATTraversal());
        this.receiver = this.msgProvider.getReceiver(msgConfig, config.getSelfPort(), config.getSelfPortRange());
        config.setSelfPort(this.receiver.getPort());
        RoutingAlgorithmProvider algoProvider = RoutingAlgorithmFactory.getProvider(config.getRoutingAlgorithm());
        this.algoConfig = algoProvider.getDefaultConfiguration();
        RoutingServiceProvider svcProvider = RoutingServiceFactory.getProvider(config.getRoutingStyle());
        RoutingService routingSvc = svcProvider.getService(svcProvider.getDefaultConfiguration(), this.msgProvider, this.receiver, algoProvider, this.algoConfig, selfID);
        algoProvider.initializeAlgorithmInstance(this.algoConfig, routingSvc);
        this.init(config, routingSvc);
    }

    public McastImpl(McastConfiguration config, RoutingService routingSvc) throws Exception {
        this.init(config, routingSvc);
    }

    private void init(McastConfiguration config, RoutingService routingSvc) throws Exception {
        this.config = config;
        this.routingSvc = routingSvc;
        this.sender = this.routingSvc.getMessageSender();
        this.neighborTable = new NeighborTable(this, this.receiver, config.getNeighborExpiration());
        this.joinedGroupSet = new GroupSet();
        this.connectRefuseGroupSet = new ExpiringSet(config.getConnectRefuseDuration());
        this.connectProhibitedNeighborMap = new ExpiringMap(config.getConnectRefuseDuration());
        this.ackConnectMessage = McastMessageFactory.getAckConnectMessage(this.getSelfIDAddressPair());
        this.nackConnectMessage = McastMessageFactory.getNackConnectMessage(this.getSelfIDAddressPair());
        this.prepareHandlers(this.routingSvc);
        this.prepareCallbacks(this.routingSvc);
        if (config.getRefreshInterval() > 0L) {
            this.refreshingThread = new Thread(new GroupRefresher());
            this.refreshingThread.setName("Refresher");
            this.refreshingThread.setDaemon(true);
            this.refreshingThread.start();
        }
        if (config.getNeighborExpireCheckInterval() > 0L) {
            this.expiringThread = new Thread(new NeighborExpirer());
            this.expiringThread.setName("NeighborExpirer");
            this.expiringThread.setDaemon(true);
            this.expiringThread.start();
        }
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort, int defaultPort) throws UnknownHostException, RoutingException {
        MessagingAddress addr = this.msgProvider.getMessagingAddress(hostAndPort, defaultPort);
        this.initialize(addr);
        return addr;
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort) throws UnknownHostException, RoutingException {
        MessagingAddress addr = this.msgProvider.getMessagingAddress(hostAndPort);
        this.initialize(addr);
        return addr;
    }

    private void initialize(MessagingAddress addr) throws RoutingException {
        this.lastKeys[0] = this.getSelfIDAddressPair().getID();
        this.lastRoutingResults[0] = this.routingSvc.join(addr);
    }

    @Override
    public void clearRoutingTable() {
        this.routingSvc.leave();
        this.lastKeys[0] = null;
        this.lastRoutingResults[0] = null;
    }

    @Override
    public void clearMcastState() {
        this.neighborTable.clear();
        this.joinedGroupSet.clear();
        this.connectRefuseGroupSet.clear();
        this.connectProhibitedNeighborMap.clear();
    }

    @Override
    public void joinGroup(ID groupID) throws RoutingException {
        this.joinedGroupSet.add(groupID);
        this.lastKeys[0] = groupID;
        this.lastRoutingResults[0] = this.routingSvc.invokeCallbacksOnRoute(groupID, 1, null, null, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean leaveGroup(ID groupID) {
        boolean ret = this.joinedGroupSet.remove(groupID);
        NeighborTable neighborTable = this.neighborTable;
        synchronized (neighborTable) {
            if (!this.neighborTable.hasChild(groupID)) {
                this.disconnectParent(groupID);
            }
            if (ret) {
                this.invokeSpanningTreeChangedCallbacks(groupID);
            }
        }
        return ret;
    }

    @Override
    public void leaveAllGroups() {
        ID[] joinedGroups = this.joinedGroupSet.toArray();
        if (joinedGroups != null) {
            ID[] iDArray = joinedGroups;
            int n = joinedGroups.length;
            int n2 = 0;
            while (n2 < n) {
                ID groupID = iDArray[n2];
                this.leaveGroup(groupID);
                ++n2;
            }
        }
    }

    @Override
    public void addSpanningTreeChangedCallback(SpanningTreeChangedCallback callback) {
        this.spanningTreeChangedCallbacks.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMulticastCallback(McastCallback callback) {
        List<McastCallback> list = this.multicastCallbacks;
        synchronized (list) {
            this.multicastCallbacks.add(callback);
        }
    }

    @Override
    public void multicast(ID groupID, Serializable payload) throws RoutingException {
        if (!this.joinedGroupSet.contains(groupID)) {
            this.joinGroup(groupID);
        }
        Message msg = McastMessageFactory.getMulticastMessage(this.getSelfIDAddressPair(), groupID, this.config.getMulticastTTL(), payload);
        this.floodMessage(groupID, msg, null);
        this.invokeMulticastCallbacks(groupID, payload);
    }

    @Override
    public synchronized void stop() {
        logger.info("Mcast#stop() called.");
        if (this.refreshingThread != null) {
            this.refreshingThread.interrupt();
            this.refreshingThread = null;
        }
        if (this.expiringThread != null) {
            this.expiringThread.interrupt();
            this.expiringThread = null;
        }
        if (this.routingSvc != null) {
            this.routingSvc.stop();
            this.routingSvc = null;
        }
    }

    @Override
    public synchronized void suspend() {
        this.routingSvc.suspend();
        this.suspended = true;
    }

    @Override
    public synchronized void resume() {
        this.routingSvc.resume();
        this.suspended = false;
        this.notifyAll();
    }

    @Override
    public ID[] getJoinedGroups() {
        return this.joinedGroupSet.toArray();
    }

    @Override
    public ID[] getGroupsWithSpanningTree() {
        ID[] ret = null;
        Set<ID> groups = this.neighborTable.getGroupsWithSpanningTree();
        int n = groups.size();
        if (n > 0) {
            ret = new ID[n];
            groups.toArray(ret);
        }
        return ret;
    }

    @Override
    public IDAddressPair getParent(ID groupID) {
        return this.neighborTable.getParent(groupID);
    }

    @Override
    public IDAddressPair[] getChildren(ID groupID) {
        return this.neighborTable.getChildren(groupID);
    }

    @Override
    public RoutingService getRoutingService() {
        return this.routingSvc;
    }

    @Override
    public McastConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration() {
        return this.algoConfig;
    }

    @Override
    public IDAddressPair getSelfIDAddressPair() {
        return this.routingSvc.getSelfIDAddressPair();
    }

    @Override
    public void setStatCollectorAddress(String host, int port) throws UnknownHostException {
        MessagingAddress addr;
        this.statCollectorAddress = addr = this.routingSvc.getMessagingProvider().getMessagingAddress(host, port);
        this.routingSvc.setStatCollectorAddress(addr);
    }

    @Override
    public ID[] getLastKeys() {
        return this.lastKeys;
    }

    @Override
    public RoutingResult[] getLastRoutingResults() {
        return this.lastRoutingResults;
    }

    @Override
    public String getRoutingTableString(int verboseLevel) {
        return this.routingSvc.getRoutingAlgorithm().getRoutingTableString(verboseLevel);
    }

    private void prepareHandlers(RoutingService routingSvc) {
        MessageHandler handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                Message repMsg;
                Serializable[] contents = msg.getContents();
                final IDAddressPair selfIDAddress = McastImpl.this.getSelfIDAddressPair();
                final ID groupID = (ID)contents[0];
                final IDAddressPair from = msg.getSource();
                if (McastImpl.this.connectRefuseGroupSet.contains(groupID)) {
                    logger.info("Refuse to be connected on " + selfIDAddress.getAddress() + ". group ID: " + groupID);
                    repMsg = McastImpl.this.nackConnectMessage;
                } else {
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean parentChanged = false;
                            NeighborTable neighborTable = McastImpl.this.neighborTable;
                            synchronized (neighborTable) {
                                IDAddressPair oldParent = McastImpl.this.neighborTable.getParent(groupID);
                                if (!from.equals(oldParent) && oldParent != null) {
                                    McastImpl.this.disconnectParent(groupID, oldParent);
                                }
                                parentChanged = McastImpl.this.neighborTable.registerParent(groupID, from);
                            }
                            if (parentChanged) {
                                McastImpl.this.invokeSpanningTreeChangedCallbacks(groupID);
                                McastImpl.this.receiver.getMessagingReporter().notifyStatCollectorOfConnectNodes(selfIDAddress, selfIDAddress.getID(), from.getID(), groupID.hashCode());
                            }
                        }
                    };
                    Thread t = new Thread(r);
                    t.setName("CONNECT handler");
                    t.setDaemon(true);
                    t.start();
                    repMsg = McastImpl.this.ackConnectMessage;
                }
                return repMsg;
            }
        };
        routingSvc.addMessageHandler(Tag.CONNECT.getNumber(), handler);
        handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID groupID = (ID)contents[0];
                NeighborTable neighborTable = McastImpl.this.neighborTable;
                synchronized (neighborTable) {
                    boolean removed = McastImpl.this.neighborTable.removeChild(groupID, msg.getSource());
                    if (removed) {
                        McastImpl.this.invokeSpanningTreeChangedCallbacks(groupID);
                    }
                }
                return null;
            }
        };
        routingSvc.addMessageHandler(Tag.DISCONNECT.getNumber(), handler);
        handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID groupID = (ID)contents[0];
                IDAddressPair source = msg.getSource();
                McastImpl.this.connectProhibitedNeighborMap.put(groupID, source.getAddress());
                NeighborTable neighborTable = McastImpl.this.neighborTable;
                synchronized (neighborTable) {
                    boolean removed = McastImpl.this.neighborTable.removeChild(groupID, source);
                    if (removed) {
                        McastImpl.this.invokeSpanningTreeChangedCallbacks(groupID);
                    }
                }
                return null;
            }
        };
        routingSvc.addMessageHandler(Tag.DISCONNECT_AND_REFUSE.getNumber(), handler);
        handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID groupID = (ID)contents[0];
                int ttl = (Integer)contents[1];
                Serializable payload = contents[2];
                logger.info("MULTICAST msg received. groupID: " + groupID + ", ttl: " + ttl + ", from: " + msg.getSource().getAddress());
                if (ttl > 0) {
                    IDAddressPair source = msg.getSource();
                    Message newMsg = McastMessageFactory.getMulticastMessage(McastImpl.this.getSelfIDAddressPair(), groupID, ttl - 1, payload);
                    McastImpl.this.floodMessage(groupID, newMsg, source.getAddress());
                }
                McastImpl.this.invokeMulticastCallbacks(groupID, payload);
                return null;
            }
        };
        routingSvc.addMessageHandler(Tag.MULTICAST.getNumber(), handler);
    }

    private void prepareCallbacks(RoutingService routingSvc) {
        routingSvc.addCallbackOnRoute(new CallbackOnRoute(){

            @Override
            public Serializable process(final ID groupID, int tag, Serializable[] args, CallbackResultFilter ignored, final IDAddressPair lastHop, final boolean onRootNode) {
                if (lastHop != null) {
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (onRootNode) {
                                McastImpl.this.connectRefuseGroupSet.add(groupID);
                                NeighborTable neighborTable = McastImpl.this.neighborTable;
                                synchronized (neighborTable) {
                                    McastImpl.this.disconnectAndRefuseParent(groupID);
                                }
                            }
                            McastImpl.this.connectWithChild(groupID, lastHop);
                        }
                    };
                    Thread t = new Thread(r);
                    t.setName("Connector");
                    t.setDaemon(true);
                    t.start();
                }
                return null;
            }
        });
        routingSvc.addCallbackOnNodeFailure(new CallbackOnNodeFailure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fail(IDAddressPair failedNode) {
                HashSet<ID> changedGroups = new HashSet<ID>();
                NeighborTable neighborTable = McastImpl.this.neighborTable;
                synchronized (neighborTable) {
                    changedGroups.addAll(McastImpl.this.neighborTable.removeChild(failedNode));
                    changedGroups.addAll(McastImpl.this.neighborTable.removeParent(failedNode));
                    for (ID changedGroup : changedGroups) {
                        McastImpl.this.invokeSpanningTreeChangedCallbacks(changedGroup);
                    }
                }
            }
        });
    }

    private void floodMessage(ID groupID, Message msg, MessagingAddress from) {
        IDAddressPair[] children;
        MessagingAddress parent;
        logger.info("floodMessage() called on " + this.getSelfIDAddressPair().getAddress() + ". from: " + from);
        IDAddressPair parentIDAddr = this.neighborTable.getParent(groupID);
        if (parentIDAddr != null && !(parent = parentIDAddr.getAddress()).equals(from)) {
            try {
                this.sender.send(parent, msg);
            }
            catch (IOException e) {
                logger.warn("Faild to flood to the parent.", e);
            }
        }
        if ((children = this.neighborTable.getChildren(groupID)) != null) {
            IDAddressPair[] iDAddressPairArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDAddressPair child = iDAddressPairArray[n2];
                MessagingAddress childAddress = child.getAddress();
                if (!childAddress.equals(from)) {
                    try {
                        this.sender.send(childAddress, msg);
                    }
                    catch (IOException e) {
                        logger.warn("Failed to flood to a child.", e);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMulticastCallbacks(ID groupID, Serializable payload) {
        if (this.joinedGroupSet.contains(groupID)) {
            List<McastCallback> list = this.multicastCallbacks;
            synchronized (list) {
                for (McastCallback cb : this.multicastCallbacks) {
                    cb.received(groupID, payload);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithChild(ID groupID, IDAddressPair child) {
        block9: {
            MessagingAddress childAddress = child.getAddress();
            if (childAddress.equals(this.connectProhibitedNeighborMap.get(groupID))) {
                return;
            }
            Message connectMsg = McastMessageFactory.getConnectMessage(this.getSelfIDAddressPair(), groupID);
            try {
                Message ackMsg = this.sender.sendAndReceive(childAddress, connectMsg);
                if (ackMsg.getTag() == Tag.ACK_CONNECT.getNumber()) {
                    logger.info("connectWithChild succeeded: " + child);
                    NeighborTable neighborTable = this.neighborTable;
                    synchronized (neighborTable) {
                        boolean added = this.neighborTable.registerChild(groupID, child);
                        if (added) {
                            this.invokeSpanningTreeChangedCallbacks(groupID);
                        }
                        break block9;
                    }
                }
                if (ackMsg.getTag() == Tag.NACK_CONNECT.getNumber()) {
                    this.connectProhibitedNeighborMap.put(groupID, childAddress);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to connect to " + child);
            }
        }
    }

    protected void disconnectParent(ID groupID) {
        IDAddressPair parent = this.neighborTable.getParent(groupID);
        if (parent == null) {
            return;
        }
        this.disconnectParent(groupID, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectParent(ID groupID, IDAddressPair parent) {
        IDAddressPair selfIDAddress = this.getSelfIDAddressPair();
        NeighborTable neighborTable = this.neighborTable;
        synchronized (neighborTable) {
            this.neighborTable.removeParent(groupID, parent);
        }
        Message msg = McastMessageFactory.getDisconnectMessage(selfIDAddress, groupID);
        try {
            this.sender.send(parent.getAddress(), msg);
        }
        catch (IOException e) {
            logger.warn("Failed to disconnect from the parent: " + parent);
        }
        this.receiver.getMessagingReporter().notifyStatCollectorOfDisconnectNodes(selfIDAddress, selfIDAddress.getID(), parent.getID(), groupID.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAndRefuseParent(ID groupID) {
        IDAddressPair selfIDAddress = this.getSelfIDAddressPair();
        IDAddressPair parent = this.neighborTable.getParent(groupID);
        if (parent == null) {
            return;
        }
        NeighborTable neighborTable = this.neighborTable;
        synchronized (neighborTable) {
            this.neighborTable.removeParent(groupID, parent);
            this.invokeSpanningTreeChangedCallbacks(groupID);
        }
        Message msg = McastMessageFactory.getDisconnectAndRefuseMessage(selfIDAddress, groupID);
        try {
            this.sender.send(parent.getAddress(), msg);
        }
        catch (IOException e) {
            logger.warn("Failed to disconnect_and_refuse a parent: " + parent);
        }
        this.receiver.getMessagingReporter().notifyStatCollectorOfDisconnectNodes(selfIDAddress, selfIDAddress.getID(), parent.getID(), groupID.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSpanningTreeChangedCallbacks(ID groupID) {
        IDAddressPair parent = this.neighborTable.getParent(groupID);
        IDAddressPair[] children = this.neighborTable.getChildren(groupID);
        List<SpanningTreeChangedCallback> list = this.spanningTreeChangedCallbacks;
        synchronized (list) {
            for (SpanningTreeChangedCallback cb : this.spanningTreeChangedCallbacks) {
                cb.topologyChanged(groupID, parent, children);
            }
        }
    }

    static /* synthetic */ McastConfiguration access$1(McastImpl mcastImpl) {
        return mcastImpl.config;
    }

    static /* synthetic */ boolean access$2(McastImpl mcastImpl) {
        return mcastImpl.suspended;
    }

    private class GroupRefresher
    implements Runnable {
        private GroupRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block7: while (true) {
                    Thread.sleep(McastImpl.access$1(McastImpl.this).getRefreshInterval());
                    var1_1 = McastImpl.this;
                    synchronized (var1_1) {
                        while (McastImpl.access$2(McastImpl.this)) {
                            McastImpl.this.wait();
                        }
                    }
                    groups = McastImpl.this.getJoinedGroups();
                    if (groups == null) continue;
                    var5_6 = groups;
                    var4_5 = groups.length;
                    var3_4 = 0;
                    while (true) {
                        if (var3_4 < var4_5) ** break;
                        continue block7;
                        group = var5_6[var3_4];
                        try {
                            McastImpl.this.joinGroup(group);
                        }
                        catch (RoutingException e) {
                            McastImpl.logger.warn("Routing failed when joining " + group, e);
                        }
                        ++var3_4;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                McastImpl.logger.warn("GroupRefresher interrupted and die.", e);
                return;
            }
        }
    }

    private class NeighborExpirer
    implements Runnable {
        private NeighborExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    Thread.sleep(McastImpl.access$1(McastImpl.this).getNeighborExpireCheckInterval());
                    while (McastImpl.access$2(McastImpl.this)) {
                        var1_1 = McastImpl.this;
                        synchronized (var1_1) {
                            McastImpl.this.wait();
                        }
                    }
                    var1_1 = McastImpl.access$3(McastImpl.this);
                    synchronized (var1_1) {
                        changedGroups = McastImpl.access$3(McastImpl.this).expire();
                        for (ID groupID : changedGroups) {
                            McastImpl.access$4(McastImpl.this, groupID);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                McastImpl.logger.warn("NeighborExpirer interrupted and die.", e);
                return;
            }
            {
                ** while (true)
            }
        }
    }
}

