/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging;

public final class Signature {
    public static final byte APPLICATION_ID_DHT_SHELL = 1;
    public static final byte APPLICATION_ID_GROUP_MANAGER_SHELL = 2;
    public static final byte APPLICATION_ID_ALM_ROUTER = 3;
    public static final byte APPLICATION_ID_MEMCACHED = 4;
    private static final byte[] SIGNATURE = new byte[]{79, 87};
    private static final int SIGNATURE_LENGTH = 8;

    public static int getSignatureLength() {
        return 8;
    }

    public static byte[] getSignature(byte routingStyleID, byte routingAlgorithmID, short applicationID, short applicationVersion) {
        byte[] sig = Signature.getAllAcceptingSignature();
        sig[2] = routingStyleID;
        sig[3] = routingAlgorithmID;
        sig[4] = (byte)(applicationID >>> 8);
        sig[5] = (byte)applicationID;
        sig[6] = (byte)(applicationVersion >>> 8);
        sig[7] = (byte)applicationVersion;
        return sig;
    }

    public static byte[] getAllAcceptingSignature() {
        byte[] sig = new byte[8];
        sig[0] = SIGNATURE[0];
        sig[1] = SIGNATURE[1];
        return sig;
    }

    public static short getAllAcceptingApplicationID() {
        return 0;
    }

    public static short getAllAcceptingApplicationVersion() {
        return 0;
    }

    public static boolean match(byte[] signature, byte[] acceptableSignature) {
        block8: {
            int i;
            int len;
            block7: {
                block6: {
                    len = Signature.getSignatureLength();
                    i = 0;
                    while (i < len) {
                        if (signature[i] == acceptableSignature[i]) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    return true;
                }
                i = 3;
                while (i < len) {
                    if (acceptableSignature[i] == 0) {
                        ++i;
                        continue;
                    }
                    break block7;
                }
                return true;
            }
            i = 3;
            while (i < len) {
                if (signature[i] == 0) {
                    ++i;
                    continue;
                }
                break block8;
            }
            return true;
        }
        return false;
    }

    public static String toString(byte[] signature) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (signature != null) {
            int i = 0;
            sb.append(Integer.toHexString(signature[i]));
            i = 1;
            while (i < signature.length) {
                sb.append(",");
                sb.append(Integer.toHexString(signature[i]));
                ++i;
            }
        } else {
            sb.append("null");
        }
        sb.append("}");
        return sb.toString();
    }
}

