/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.distemulator;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.messaging.distemulator.DEmuMessageFactory;
import ow.messaging.distemulator.DEmuMessageSender;
import ow.messaging.distemulator.DEmuMessagingProvider;
import ow.messaging.emulator.EmuMessageReceiver;
import ow.messaging.emulator.EmuMessageSender;
import ow.stat.MessagingReporter;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.tool.emulator.RemoteControlPipeTable;

public final class DEmuMessageReceiver
implements MessageReceiver {
    public static Log logger = LogFactory.getLog(DEmuMessageReceiver.class);
    private InetAddress selfInetAddress;
    private MessagingAddress selfNetAddress;
    private final DEmuMessagingProvider provider;
    private final EmuMessageReceiver emuReceiver;
    private final MessageReceiver netReceiver;
    private final MessagingProvider netProvider;
    private final RemoteControlPipeTable hostTable;
    private final EmuMessageSender emuSender;
    private final MessagingReporter msgReporter;

    protected DEmuMessageReceiver(InetAddress selfInetAddr, MessagingAddress selfNetAddress, DEmuMessagingProvider provider, EmuMessageReceiver emuReceiver, MessageReceiver netReceiver, MessagingProvider netProvider, RemoteControlPipeTable hostTable) throws UnknownHostException {
        this.selfInetAddress = selfInetAddr;
        this.selfNetAddress = selfNetAddress;
        this.provider = provider;
        this.emuReceiver = emuReceiver;
        this.netReceiver = netReceiver;
        this.netProvider = netProvider;
        this.hostTable = hostTable;
        if (this.selfInetAddress == null) {
            this.selfInetAddress = InetAddress.getLocalHost();
        }
        this.emuSender = (EmuMessageSender)this.emuReceiver.getSender();
        StatConfiguration conf = StatFactory.getDefaultConfiguration();
        this.msgReporter = StatFactory.getMessagingReporter(conf, this.provider, this.getSender());
    }

    @Override
    public MessagingReporter getMessagingReporter() {
        return this.msgReporter;
    }

    @Override
    public MessageSender getSender() {
        EmuMessageSender emuSender = (EmuMessageSender)this.emuReceiver.getSender();
        MessageSender netSender = this.netReceiver.getSender();
        return new DEmuMessageSender(this.selfInetAddress, this.selfNetAddress, emuSender, netSender, this.netProvider, this.hostTable, this.msgReporter);
    }

    @Override
    public void addHandler(MessageHandler handler) {
        this.emuReceiver.addHandler(handler);
        TunnelingMessageHandler h = new TunnelingMessageHandler(handler, this.emuSender);
        this.netReceiver.addHandler(h);
    }

    @Override
    public void removeHandler(MessageHandler handler) {
        this.emuReceiver.removeHandler(handler);
        TunnelingMessageHandler h = new TunnelingMessageHandler(handler, this.emuSender);
        this.netReceiver.removeHandler(h);
    }

    @Override
    public MessagingAddress getSelfAddress() {
        return this.emuReceiver.getSelfAddress();
    }

    @Override
    public void setSelfAddress(String hostname) {
        this.emuReceiver.setSelfAddress(hostname);
    }

    @Override
    public int getPort() {
        return this.emuReceiver.getPort();
    }

    @Override
    public void stop() {
        this.emuReceiver.stop();
        this.netReceiver.stop();
    }

    @Override
    public void start() {
        this.emuReceiver.start();
        this.netReceiver.start();
    }

    private class TunnelingMessageHandler
    implements MessageHandler {
        private final MessageHandler enclosedHandler;
        private final EmuMessageSender emuSender;

        TunnelingMessageHandler(MessageHandler handler, EmuMessageSender emuSender) {
            this.enclosedHandler = handler;
            this.emuSender = emuSender;
        }

        @Override
        public Message process(Message msg) {
            Message ret = null;
            if (msg.getTag() != Tag.ENCAPSULATED.getNumber()) {
                return null;
            }
            Serializable[] contents = msg.getContents();
            MessagingAddress dest = (MessagingAddress)contents[0];
            Message enclosedMessage = (Message)contents[1];
            boolean roundtrip = (Boolean)contents[2];
            try {
                if (roundtrip) {
                    ret = this.emuSender.sendAndReceive(dest, enclosedMessage);
                } else {
                    this.emuSender.send(dest, enclosedMessage);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to send into emulator: " + dest);
                DEmuMessageReceiver.this.msgReporter.notifyStatCollectorOfDeletedNode(enclosedMessage.getSource(), dest, enclosedMessage.getTag());
            }
            if (ret != null) {
                ret = DEmuMessageFactory.getEncapsulatedMessage(IDAddressPair.getIDAddressPair(null, DEmuMessageReceiver.this.selfNetAddress), msg.getSource().getAddress(), ret, false);
            }
            return ret;
        }

        public boolean equals(Object o) {
            TunnelingMessageHandler h = (TunnelingMessageHandler)o;
            return this.enclosedHandler.equals(h.enclosedHandler);
        }

        public int hashCode() {
            return this.enclosedHandler.hashCode() + 1;
        }
    }
}

