/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.distemulator;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.messaging.distemulator.DEmuMessageFactory;
import ow.messaging.emulator.EmuMessageSender;
import ow.messaging.emulator.EmuMessagingAddress;
import ow.messaging.util.MessagingUtility;
import ow.stat.MessagingReporter;
import ow.tool.emulator.RemoteControlPipeTable;

public final class DEmuMessageSender
implements MessageSender {
    public static Log logger = LogFactory.getLog(DEmuMessageSender.class);
    private final InetAddress selfInetAddress;
    private final MessagingAddress selfNetAddress;
    private final EmuMessageSender emuSender;
    private final MessageSender netSender;
    private final MessagingProvider netProvider;
    private final RemoteControlPipeTable hostTable;
    private MessagingReporter msgReporter;

    DEmuMessageSender(InetAddress selfInetAddress, MessagingAddress selfNetAddress, EmuMessageSender emuSender, MessageSender netSender, MessagingProvider netProvider, RemoteControlPipeTable hostTable, MessagingReporter msgReporter) {
        this.selfInetAddress = selfInetAddress;
        this.selfNetAddress = selfNetAddress;
        this.emuSender = emuSender;
        this.netSender = netSender;
        this.netProvider = netProvider;
        this.hostTable = hostTable;
        this.msgReporter = msgReporter;
    }

    public void setMessagingReporter(MessagingReporter msgReporter) {
        this.msgReporter = msgReporter;
    }

    @Override
    public void send(MessagingAddress dest, Message msg) throws IOException {
        MessagingUtility.HostAndPort netDest = this.getEmulatorHostAndPort(dest);
        if (netDest == null) {
            logger.warn("Could not find a worker: " + dest);
            return;
        }
        try {
            if (netDest.getHostAddress().equals(this.selfInetAddress)) {
                this.emuSender.send(dest, msg);
            } else {
                Message encapsulated = DEmuMessageFactory.getEncapsulatedMessage(IDAddressPair.getIDAddressPair(null, this.selfNetAddress), dest, msg, false);
                MessagingAddress netAddress = this.netProvider.getMessagingAddress(netDest.getHostName(), netDest.getPort());
                this.netSender.send(netAddress, encapsulated);
            }
        }
        catch (IOException e) {
            if (this.msgReporter != null) {
                this.msgReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw e;
        }
        if (this.msgReporter != null) {
            this.msgReporter.notifyStatCollectorOfMessageSent(dest, msg, 0);
        }
    }

    @Override
    public Message sendAndReceive(MessagingAddress dest, Message msg) throws IOException {
        Message ret = null;
        MessagingUtility.HostAndPort netDest = this.getEmulatorHostAndPort(dest);
        if (netDest == null) {
            logger.warn("Could not find a worker: " + dest);
            return null;
        }
        try {
            if (netDest.getHostAddress().equals(this.selfInetAddress)) {
                ret = this.emuSender.sendAndReceive(dest, msg);
            } else {
                Message encapsulated = DEmuMessageFactory.getEncapsulatedMessage(IDAddressPair.getIDAddressPair(null, this.selfNetAddress), dest, msg, true);
                MessagingAddress netAddress = this.netProvider.getMessagingAddress(netDest.getHostName(), netDest.getPort());
                encapsulated = this.netSender.sendAndReceive(netAddress, encapsulated);
                if (encapsulated.getTag() == Tag.ENCAPSULATED.getNumber()) {
                    Serializable[] contents = encapsulated.getContents();
                    ret = (Message)contents[1];
                }
            }
        }
        catch (IOException e) {
            if (this.msgReporter != null) {
                this.msgReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw e;
        }
        if (this.msgReporter != null) {
            this.msgReporter.notifyStatCollectorOfMessageSent(dest, msg, 0);
        }
        return ret;
    }

    private MessagingUtility.HostAndPort getEmulatorHostAndPort(MessagingAddress dest) {
        EmuMessagingAddress emuDest = (EmuMessagingAddress)dest;
        int destID = emuDest.getEmuHostID().getHostID();
        return this.hostTable.getWorkerHostAndPort(destID);
    }
}

