/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.distemulator;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchProviderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.messaging.AbstractMessagingProvider;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.distemulator.DEmuMessageReceiver;
import ow.messaging.distemulator.DEmuMessagingConfiguration;
import ow.messaging.emulator.EmuMessageReceiver;
import ow.messaging.emulator.EmuMessagingProvider;

public class DEmuMessagingProvider
extends AbstractMessagingProvider {
    public static Log logger = LogFactory.getLog(DEmuMessagingProvider.class);
    private static final String NAME = "DistributedEmulator";
    EmuMessagingProvider emuProvider;
    MessagingProvider netProvider;
    MessageReceiver netReceiver = null;
    byte[] messageSignature = null;
    String selfAddress = null;
    InetAddress selfInetAddress;
    private MessagingAddress statCollectorAddress = null;

    public DEmuMessagingProvider() {
        try {
            this.emuProvider = (EmuMessagingProvider)MessagingFactory.getProvider("Emulator", null, true);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isReliable() {
        return false;
    }

    @Override
    public MessagingConfiguration getDefaultConfiguration() {
        DEmuMessagingConfiguration config = new DEmuMessagingConfiguration();
        config.setInitialID(MessagingFactory.INITIAL_EMULATOR_HOST_ID);
        config.setHostTable(MessagingFactory.HOST_TABLE_FOR_DIST_EMULATOR);
        return config;
    }

    @Override
    public MessageReceiver getReceiver(MessagingConfiguration config, int port) throws IOException {
        return this.getReceiver(config, port, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReceiver getReceiver(MessagingConfiguration config, int port, int portRange) throws IOException {
        DEmuMessagingConfiguration demuConf;
        block8: {
            demuConf = (DEmuMessagingConfiguration)config;
            DEmuMessagingProvider dEmuMessagingProvider = this;
            synchronized (dEmuMessagingProvider) {
                if (this.netReceiver != null) break block8;
                String type = demuConf.getRemoteMessagingTransport();
                try {
                    this.netProvider = MessagingFactory.getProvider(type, this.getMessageSignature(), true);
                }
                catch (NoSuchProviderException e) {
                    logger.fatal("No such messaging provider: " + type, e);
                    return null;
                }
                if (this.selfAddress != null) {
                    this.netProvider.setSelfAddress(this.selfAddress);
                }
                if (this.messageSignature != null) {
                    this.netProvider.setMessageSignature(this.messageSignature);
                }
                MessagingConfiguration netConfig = this.netProvider.getDefaultConfiguration();
                this.netReceiver = this.netProvider.getReceiver(netConfig, demuConf.getNetPort(), demuConf.getNetPortRange());
            }
        }
        MessagingConfiguration emuConfig = this.emuProvider.getDefaultConfiguration();
        EmuMessageReceiver emuReceiver = (EmuMessageReceiver)this.emuProvider.getReceiver(emuConfig, demuConf.getNetPort(), demuConf.getNetPortRange());
        return new DEmuMessageReceiver(this.selfInetAddress, this.netReceiver.getSelfAddress(), this, emuReceiver, this.netReceiver, this.netProvider, demuConf.getHostTable());
    }

    @Override
    public MessagingAddress getMessagingAddress(String hostAndPort, int defaultPort) throws UnknownHostException {
        return this.emuProvider.getMessagingAddress(hostAndPort, defaultPort);
    }

    @Override
    public MessagingAddress getMessagingAddress(String hostAndPort) throws UnknownHostException {
        return this.emuProvider.getMessagingAddress(hostAndPort);
    }

    @Override
    public MessagingAddress getMessagingAddress(int port) {
        return this.emuProvider.getMessagingAddress(port);
    }

    @Override
    public byte[] setMessageSignature(byte[] signature) {
        this.messageSignature = signature;
        if (this.netProvider != null) {
            this.netProvider.setMessageSignature(signature);
        }
        return this.emuProvider.setMessageSignature(signature);
    }

    @Override
    public byte[] getMessageSignature() {
        return this.emuProvider.getMessageSignature();
    }

    @Override
    public MessagingAddress getMessagingCollectorAddress() {
        return this.statCollectorAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagingAddress setMessagingCollectorAddress(MessagingAddress addr) {
        MessagingAddress old;
        DEmuMessagingProvider dEmuMessagingProvider = this;
        synchronized (dEmuMessagingProvider) {
            old = this.statCollectorAddress;
            this.statCollectorAddress = addr;
        }
        return old;
    }

    @Override
    public MessagingProvider substitute() {
        DEmuMessagingProvider newProvider = new DEmuMessagingProvider();
        return newProvider;
    }

    @Override
    public void setSelfAddress(String host) throws UnknownHostException {
        this.selfAddress = host;
        this.selfInetAddress = InetAddress.getLocalHost();
        if (this.netProvider != null) {
            this.netProvider.setSelfAddress(host);
        }
        this.emuProvider.setSelfAddress(host);
    }
}

