/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.messaging.ExtendedMessageHandler;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.emulator.EmuHostID;
import ow.messaging.emulator.EmuMessageSender;
import ow.messaging.emulator.EmuMessagingAddress;
import ow.messaging.emulator.EmuMessagingConfiguration;
import ow.messaging.emulator.EmuMessagingProvider;
import ow.messaging.emulator.SleepPeriodMeasure;
import ow.stat.MessagingReporter;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class EmuMessageReceiver
implements MessageReceiver {
    public static Log logger = LogFactory.getLog(EmuMessageReceiver.class);
    private static Map<EmuMessagingAddress, EmuMessageReceiver> receiverTable = new ConcurrentHashMap<EmuMessagingAddress, EmuMessageReceiver>();
    final EmuMessagingConfiguration config;
    private EmuMessagingAddress selfAddr;
    protected final EmuMessagingProvider provider;
    private final EmuMessageSender singletonSender;
    private final MessagingReporter msgReporter;
    private List<MessageHandler> handlerList = new ArrayList<MessageHandler>();
    private List<ExtendedMessageHandler> extendedHandlerList = new ArrayList<ExtendedMessageHandler>();
    private int numExtendedHandler = 0;
    private long latencyMillis;
    private int latencyNanos;
    private final SleepPeriodMeasure sleepPeriodMeasure;
    final boolean communicationCanFail;
    private static boolean oomPrinted = false;

    protected EmuMessageReceiver(EmuMessagingConfiguration config, EmuHostID selfInetAddr, int port, EmuMessagingProvider provider) {
        this.config = config;
        this.selfAddr = new EmuMessagingAddress(selfInetAddr, port);
        this.provider = provider;
        this.singletonSender = new EmuMessageSender(this);
        StatConfiguration conf = StatFactory.getDefaultConfiguration();
        this.msgReporter = StatFactory.getMessagingReporter(conf, this.provider, this.getSender());
        long latencyMicros = config.getAdditionalLatencyMicros();
        if (latencyMicros > 0L) {
            this.latencyMillis = latencyMicros / 1000L;
            this.latencyNanos = (int)(latencyMicros - 1000L * this.latencyMillis) * 1000;
            this.sleepPeriodMeasure = new SleepPeriodMeasure();
        } else {
            this.sleepPeriodMeasure = null;
        }
        this.communicationCanFail = config.getCommunicationFailureRate() > 0.0;
    }

    @Override
    public MessagingAddress getSelfAddress() {
        return this.selfAddr;
    }

    @Override
    public void setSelfAddress(String hostname) {
        this.selfAddr = (EmuMessagingAddress)this.provider.getMessagingAddress(hostname, this.selfAddr.getPort());
    }

    @Override
    public int getPort() {
        return this.selfAddr.getPort();
    }

    @Override
    public MessagingReporter getMessagingReporter() {
        return this.msgReporter;
    }

    @Override
    public void start() {
        receiverTable.put(this.selfAddr, this);
    }

    @Override
    public synchronized void stop() {
        receiverTable.remove(this.selfAddr);
    }

    @Override
    public MessageSender getSender() {
        return this.singletonSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(MessageHandler handler) {
        List<MessageHandler> list = this.handlerList;
        synchronized (list) {
            this.handlerList.add(handler);
            try {
                this.extendedHandlerList.add((ExtendedMessageHandler)handler);
                ++this.numExtendedHandler;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(MessageHandler handler) {
        List<MessageHandler> list = this.handlerList;
        synchronized (list) {
            this.handlerList.remove(handler);
            try {
                this.extendedHandlerList.remove((ExtendedMessageHandler)handler);
                --this.numExtendedHandler;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected static EmuMessageReceiver getReceiver(MessagingAddress dest) {
        EmuMessageReceiver receiver = null;
        receiver = receiverTable.get(dest);
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Message processAMessage(final Message msg) {
        block20: {
            if (this.sleepPeriodMeasure != null) {
                try {
                    this.sleepPeriodMeasure.sleep(this.latencyMillis, this.latencyNanos);
                }
                catch (InterruptedException var2_2) {
                    // empty catch block
                }
            }
            ret = null;
            for (MessageHandler handler : this.handlerList) {
                try {
                    ret = handler.process(msg);
                }
                catch (Throwable e) {
                    EmuMessageReceiver.logger.fatal("A MessageHandler threw an Exception.", e);
                }
            }
            if (this.numExtendedHandler <= 0) break block20;
            r = new Runnable(){

                @Override
                public void run() {
                    for (ExtendedMessageHandler handler : EmuMessageReceiver.this.extendedHandlerList) {
                        try {
                            handler.postProcess(msg);
                        }
                        catch (Throwable e) {
                            logger.fatal("A MessageHandler threw an Exception.", e);
                        }
                    }
                }
            };
            try {
                if (this.config.getUseThreadPool()) {
                    ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                    ex.submit(r);
                } else {
                    t = new Thread(r);
                    t.setDaemon(false);
                    t.setName("EmuMessageReceiver (post-process): " + msg);
                    t.start();
                }
            }
            catch (OutOfMemoryError e) {
                try {
                    Thread.currentThread().setPriority(10);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                EmuMessageReceiver.logger.fatal("# of threads: " + Thread.activeCount(), e);
                doesPrint = false;
                var6_12 = EmuMessageReceiver.class;
                synchronized (EmuMessageReceiver.class) {
                    if (!EmuMessageReceiver.oomPrinted) {
                        EmuMessageReceiver.oomPrinted = true;
                        doesPrint = true;
                    }
                    // ** MonitorExit[var6_12] (shouldn't be in output)
                    if (doesPrint == false) throw e;
                    tarray = new Thread[Thread.activeCount()];
                    Thread.enumerate(tarray);
                    var10_13 = tarray;
                    var9_14 = tarray.length;
                    var8_15 = 0;
                    if (true) ** GOTO lbl67
                }
            }
        }
        if (this.sleepPeriodMeasure == null) return ret;
        try {
            this.sleepPeriodMeasure.sleep(this.latencyMillis, this.latencyNanos);
            return ret;
        }
        catch (InterruptedException var3_7) {
            // empty catch block
        }
        return ret;
        {
            do {
                if ((t = var10_13[var8_15]) != null) {
                    System.out.println("Th: " + t.getName());
                }
                ++var8_15;
lbl67:
                // 2 sources

            } while (var8_15 < var9_14);
            System.out.flush();
            Runtime.getRuntime().halt(1);
            throw e;
        }
    }
}

