/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ow.messaging.AbstractMessagingProvider;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.emulator.EmuHostID;
import ow.messaging.emulator.EmuMessageReceiver;
import ow.messaging.emulator.EmuMessagingAddress;
import ow.messaging.emulator.EmuMessagingConfiguration;
import ow.messaging.util.MessagingUtility;

public final class EmuMessagingProvider
extends AbstractMessagingProvider {
    private static final String NAME = "Emulator";
    private EmuHostID selfHostID = null;
    private final Map<Thread, EmuMessageReceiver> receiverTable = new HashMap<Thread, EmuMessageReceiver>();
    private MessagingAddress statCollectorAddress = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public MessagingConfiguration getDefaultConfiguration() {
        EmuMessagingConfiguration config = new EmuMessagingConfiguration();
        config.setInitialID(MessagingFactory.INITIAL_EMULATOR_HOST_ID);
        return config;
    }

    @Override
    public MessageReceiver getReceiver(MessagingConfiguration config, int port) throws IOException {
        return this.getReceiver(config, port, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReceiver getReceiver(MessagingConfiguration config, int port, int portRange) throws IOException {
        EmuMessageReceiver receiver;
        EmuMessagingConfiguration emuConfig = (EmuMessagingConfiguration)config;
        EmuHostID.setInitialID(emuConfig.getInitialID());
        if (this.selfHostID == null) {
            this.selfHostID = EmuHostID.getNewInstance();
        }
        Thread curThread = Thread.currentThread();
        Map<Thread, EmuMessageReceiver> map = this.receiverTable;
        synchronized (map) {
            receiver = this.receiverTable.get(curThread);
            if (receiver == null) {
                receiver = new EmuMessageReceiver(emuConfig, this.selfHostID, port, this);
                this.receiverTable.put(curThread, receiver);
                receiver.start();
            }
        }
        return receiver;
    }

    @Override
    public MessagingAddress getMessagingAddress(String hostname, int port) {
        EmuHostID host = EmuHostID.resolve(hostname);
        if (host == null) {
            return null;
        }
        return new EmuMessagingAddress(host, port);
    }

    @Override
    public MessagingAddress getMessagingAddress(String hostAndPortStr) {
        MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(hostAndPortStr);
        EmuHostID host = EmuHostID.resolve(hostAndPort.getHostName());
        if (host == null) {
            return null;
        }
        return new EmuMessagingAddress(host, hostAndPort.getPort());
    }

    @Override
    public EmuMessagingAddress getMessagingAddress(int port) {
        return new EmuMessagingAddress(this.selfHostID, port);
    }

    @Override
    public MessagingAddress getMessagingCollectorAddress() {
        return this.statCollectorAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagingAddress setMessagingCollectorAddress(MessagingAddress addr) {
        MessagingAddress old;
        EmuMessagingProvider emuMessagingProvider = this;
        synchronized (emuMessagingProvider) {
            old = this.statCollectorAddress;
            this.statCollectorAddress = addr;
        }
        return old;
    }

    @Override
    public MessagingProvider substitute() {
        EmuMessagingProvider newProvider = new EmuMessagingProvider();
        return newProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelfAddress(String hostname) {
        Map<Thread, EmuMessageReceiver> map = this.receiverTable;
        synchronized (map) {
            for (EmuMessageReceiver receiver : this.receiverTable.values()) {
                receiver.setSelfAddress(hostname);
            }
        }
    }
}

