/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.tcp;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ConnectionPool {
    public static Log logger = LogFactory.getLog(ConnectionPool.class);
    private final int size;
    private final Map<SocketAddress, SocketChannel> connectionMap;
    private final Random rnd;

    ConnectionPool(int size) {
        this.size = size;
        this.connectionMap = Collections.synchronizedMap(new HashMap());
        this.rnd = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel get(SocketAddress dest) throws IOException {
        SocketChannel sock = this.connectionMap.remove(dest);
        if (sock != null) {
            logger.info("A Socket found in the hash table: " + sock.toString());
            return sock;
        }
        try {
            sock = SocketChannel.open(dest);
            logger.info("A new Socket created: " + dest);
        }
        catch (IOException e) {
            logger.info("A Socket could not be created: " + dest);
            throw e;
        }
        if (this.connectionMap.size() + 1 >= this.size) {
            logger.info("Connection pool is full. Remove an entry.");
            int removeIdx = this.rnd.nextInt(this.size);
            SocketAddress removedKey = null;
            Map<SocketAddress, SocketChannel> map = this.connectionMap;
            synchronized (map) {
                for (SocketAddress key : this.connectionMap.keySet()) {
                    if (removeIdx == 0) {
                        removedKey = key;
                        break;
                    }
                    --removeIdx;
                }
                this.connectionMap.remove(removedKey);
            }
        }
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(SocketAddress addr, SocketChannel sock) {
        Map<SocketAddress, SocketChannel> map = this.connectionMap;
        synchronized (map) {
            SocketChannel existingChannel = this.connectionMap.remove(addr);
            if (existingChannel != null) {
                try {
                    existingChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                existingChannel = null;
            }
            this.connectionMap.put(addr, sock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<SocketAddress, SocketChannel> map = this.connectionMap;
        synchronized (map) {
            for (SocketChannel sock : this.connectionMap.values()) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.connectionMap.clear();
        }
    }
}

