/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.IDAddressPair;
import ow.messaging.ExtendedMessageHandler;
import ow.messaging.InetMessagingAddress;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Signature;
import ow.messaging.tcp.ConnectionPool;
import ow.messaging.tcp.TCPMessageSender;
import ow.messaging.tcp.TCPMessagingConfiguration;
import ow.messaging.tcp.TCPMessagingProvider;
import ow.messaging.upnp.Mapping;
import ow.messaging.util.UPnPAddressPortMapper;
import ow.stat.MessagingReporter;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public class TCPMessageReceiver
implements MessageReceiver,
Runnable {
    public static Log logger = LogFactory.getLog(TCPMessageReceiver.class);
    private InetMessagingAddress selfAddr;
    private ServerSocketChannel servSock;
    protected TCPMessagingConfiguration config;
    protected TCPMessagingProvider provider;
    protected ConnectionPool connPool;
    private Thread receiverThread;
    private Set<Thread> handlerThreads = Collections.synchronizedSet(new HashSet());
    private List<MessageHandler> handlerList = new ArrayList<MessageHandler>();
    protected boolean extMessageHandlerRegistered = false;
    private final MessagingReporter msgReporter;
    private static boolean oomPrinted = false;

    protected TCPMessageReceiver(InetAddress selfInetAddr, int port, int portRange, TCPMessagingConfiguration config, TCPMessagingProvider provider) throws IOException {
        InetMessagingAddress boundAddr;
        this.config = config;
        this.provider = provider;
        this.servSock = ServerSocketChannel.open();
        if (selfInetAddr == null) {
            selfInetAddr = InetAddress.getLocalHost();
        }
        ServerSocket s = this.servSock.socket();
        s.setReuseAddress(true);
        this.selfAddr = this.bind(s, selfInetAddr, port, portRange);
        if (this.selfAddr == null && !selfInetAddr.equals(InetAddress.getLocalHost()) && (boundAddr = this.bind(s, InetAddress.getLocalHost(), port, portRange)) != null) {
            boundAddr.setInetAddress(selfInetAddr);
            this.selfAddr = boundAddr;
        }
        if (this.selfAddr == null) {
            String addrPort = String.valueOf(selfInetAddr.getHostAddress()) + ":" + port + "-" + (port + portRange - 1);
            logger.fatal("Could not bind to " + addrPort + "." + " Specify self hostname with -s option.");
            throw new IOException("Bind failed: " + addrPort);
        }
        this.connPool = new ConnectionPool(config.getConnectionPoolSize());
        StatConfiguration conf = StatFactory.getDefaultConfiguration();
        this.msgReporter = StatFactory.getMessagingReporter(conf, this.provider, this.getSender());
        if (this.config.getDoUPnPNATTraversal()) {
            String internalAddress = this.selfAddr.getHostAddress();
            UPnPAddressPortMapper.start(internalAddress, port, Mapping.Protocol.TCP, "Overlay Weaver", this.provider, config.getUPnPTimeout());
        }
    }

    private InetMessagingAddress bind(ServerSocket sock, InetAddress inetAddr, int port, int range) {
        InetMessagingAddress addr = null;
        boolean bound = false;
        if (range <= 0) {
            range = 1;
        }
        int i = 0;
        while (i < range) {
            addr = new InetMessagingAddress(inetAddr, port + i);
            try {
                InetSocketAddress bindAddr = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port + i);
                sock.bind(bindAddr);
                port += i;
                bound = true;
                break;
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        if (!bound) {
            addr = null;
        }
        return addr;
    }

    @Override
    public MessagingAddress getSelfAddress() {
        return this.selfAddr;
    }

    @Override
    public void setSelfAddress(String hostOrIP) {
        try {
            this.selfAddr = this.provider.getMessagingAddress(hostOrIP, this.selfAddr.getPort());
        }
        catch (UnknownHostException e) {
            logger.warn("Could not resolve a hostname: " + hostOrIP);
        }
    }

    @Override
    public int getPort() {
        return this.selfAddr.getPort();
    }

    @Override
    public MessagingReporter getMessagingReporter() {
        return this.msgReporter;
    }

    @Override
    public MessageSender getSender() {
        return new TCPMessageSender(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            if (this.receiverThread == null) {
                this.receiverThread = new Thread(this);
                this.receiverThread.setDaemon(true);
                this.receiverThread.setName("TCPMessageReceiver");
                this.receiverThread.setPriority(Thread.currentThread().getPriority() + this.config.getReceiverThreadPriority());
                this.receiverThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            if (this.receiverThread != null) {
                this.receiverThread.interrupt();
                this.receiverThread = null;
            }
        }
        Thread[] handlerArray = new Thread[this.handlerThreads.size()];
        this.handlerThreads.toArray(handlerArray);
        int i = 0;
        while (i < handlerArray.length) {
            handlerArray[i].interrupt();
            ++i;
        }
        this.handlerThreads.clear();
        this.msgReporter.notifyStatCollectorOfDeletedNode(IDAddressPair.getIDAddressPair(null, (MessagingAddress)this.selfAddr), this.selfAddr, -1);
        this.connPool.clear();
    }

    @Override
    public void run() {
        while (true) {
            SocketChannel sock = null;
            try {
                sock = this.servSock.accept();
            }
            catch (IOException e) {
                logger.warn("ServerSocket#accept() threw an Exception and the receiver will die.");
                return;
            }
            TCPMessageHandler r = new TCPMessageHandler(sock);
            try {
                if (this.config.getUseThreadPool()) {
                    GlobalThreadPoolExecutors.getThreadPool(false, false, false).submit(r);
                    continue;
                }
                Thread handlerThread = new Thread(r);
                handlerThread.setDaemon(false);
                this.handlerThreads.add(handlerThread);
                handlerThread.start();
            }
            catch (OutOfMemoryError e) {
                logger.fatal("# of threads: " + Thread.activeCount(), e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(MessageHandler handler) {
        ArrayList<MessageHandler> newHandlerList = new ArrayList<MessageHandler>();
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            newHandlerList.addAll(this.handlerList);
            newHandlerList.add(handler);
            this.handlerList = newHandlerList;
        }
        if (handler instanceof ExtendedMessageHandler) {
            this.extMessageHandlerRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(MessageHandler handler) {
        ArrayList<MessageHandler> newHandlerList = new ArrayList<MessageHandler>();
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            newHandlerList.addAll(this.handlerList);
            newHandlerList.remove(handler);
            this.handlerList = newHandlerList;
        }
        boolean exists = false;
        for (MessageHandler h : newHandlerList) {
            if (!(h instanceof ExtendedMessageHandler)) continue;
            exists = true;
            break;
        }
        this.extMessageHandlerRegistered = exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message processMessage(Message msg) {
        List<MessageHandler> currentHandlerList;
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            currentHandlerList = this.handlerList;
        }
        Message ret = null;
        for (MessageHandler handler : currentHandlerList) {
            try {
                ret = handler.process(msg);
            }
            catch (Throwable e) {
                logger.fatal("A MessageHandler#process() threw an Exception.", e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postProcessMessage(Message msg) {
        List<MessageHandler> currentHandlerList;
        if (!this.extMessageHandlerRegistered) {
            return;
        }
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            currentHandlerList = this.handlerList;
        }
        for (MessageHandler handler : currentHandlerList) {
            ExtendedMessageHandler extHandler;
            try {
                extHandler = (ExtendedMessageHandler)handler;
            }
            catch (ClassCastException e) {
                continue;
            }
            try {
                extHandler.postProcess(msg);
            }
            catch (Throwable e) {
                logger.fatal("A MessageHandler#postProcess() threw an Exception.", e);
            }
        }
    }

    private class TCPMessageHandler
    implements Runnable {
        SocketChannel sock;

        TCPMessageHandler(SocketChannel sock) {
            this.sock = sock;
        }

        @Override
        public void run() {
            Thread th = Thread.currentThread();
            String origName = th.getName();
            th.setName("TCPMessageHandler: " + this.sock.socket().getInetAddress());
            while (!Thread.interrupted()) {
                Message msg;
                block11: {
                    msg = null;
                    try {
                        msg = Message.decode(this.sock);
                    }
                    catch (IOException e0) {
                        logger.info("No Message could not be decoded (or just closed).");
                        try {
                            this.sock.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    byte[] sig = msg.getSignature();
                    byte[] acceptableSig = TCPMessageReceiver.this.provider.getMessageSignature();
                    if (!Signature.match(sig, acceptableSig)) continue;
                    Message ret = TCPMessageReceiver.this.processMessage(msg);
                    if (ret != null) {
                        logger.info("Return a message: " + ret);
                        MessagingAddress src = msg.getSource() != null ? msg.getSource().getAddress() : null;
                        try {
                            ByteBuffer buf = Message.encode(this.sock, ret);
                            if (src != null) {
                                TCPMessageReceiver.this.msgReporter.notifyStatCollectorOfMessageSent(src, ret, buf.remaining());
                            }
                            break block11;
                        }
                        catch (IOException e) {
                            logger.warn("Could not return a message (or just closed).");
                            try {
                                this.sock.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (src == null) break;
                            TCPMessageReceiver.this.msgReporter.notifyStatCollectorOfDeletedNode(ret.getSource(), src, ret.getTag());
                            break;
                        }
                    }
                    logger.info("Return no message.");
                }
                TCPMessageReceiver.this.postProcessMessage(msg);
            }
            TCPMessageReceiver.this.handlerThreads.remove(Thread.currentThread());
            th.setName(origName);
        }
    }
}

