/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.IDAddressPair;
import ow.messaging.InetMessagingAddress;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.messaging.udp.UDPMessageReceiver;
import ow.stat.MessagingReporter;
import ow.util.AlarmClock;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class UDPMessageSender
implements MessageSender {
    public static Log logger = LogFactory.getLog(UDPMessageSender.class);
    protected static final int MAX_MSG_SIZE = 65536;
    private final UDPMessageReceiver receiver;
    private final boolean forReceiver;

    protected UDPMessageSender(UDPMessageReceiver receiver, boolean forReceiver) {
        this.receiver = receiver;
        this.forReceiver = forReceiver;
    }

    @Override
    public void send(MessagingAddress dest, Message msg) throws IOException {
        this.adjustLoopbackAddress((InetMessagingAddress)dest);
        MessagingAddress selfAddress = this.receiver.getSelfAddress();
        if (dest.equals(selfAddress)) {
            this.receiver.processMessage(msg);
            this.receiver.postProcessMessage(msg);
            return;
        }
        DatagramChannel sock = !this.forReceiver ? this.receiver.sockPool.get() : this.receiver.sock;
        this.send(sock, ((InetMessagingAddress)dest).getInetSocketAddress(), dest, msg, false);
        if (!this.forReceiver) {
            this.receiver.sockPool.put(sock);
        }
    }

    protected ByteBuffer send(DatagramChannel sock, SocketAddress sockAddr, MessagingAddress dest, Message msg, boolean isReply) throws IOException {
        int tag = msg.getTag();
        if (tag != Tag.PUNCH_HOLE_REQ.getNumber() && tag != Tag.PUNCH_HOLE_REP.getNumber() && dest != null && !this.receiver.getSelfAddress().equals(dest) && !isReply && this.receiver.beginFirstPunching()) {
            this.receiver.lastSendDest = (InetMessagingAddress)dest;
            this.receiver.punchHole();
            IDAddressPair src = msg.getSource();
            if (src != null) {
                msg.setSource(IDAddressPair.getIDAddressPair(src.getID(), this.receiver.getSelfAddress()));
            }
        }
        logger.info("send(" + (dest != null ? dest : sockAddr) + ", " + Tag.getNameByNumber(msg.getTag()) + ")");
        byte[] sig = this.receiver.provider.getMessageSignature();
        msg.setSignature(sig);
        ByteBuffer buf = Message.encode(msg);
        int payloadLen = buf.remaining();
        if (payloadLen >= 65536) {
            logger.warn("message is too large: " + payloadLen);
            throw new IOException("message is too large: " + payloadLen);
        }
        try {
            sock.send(buf, sockAddr);
            buf.rewind();
            if (dest != null) {
                this.receiver.setLastSend((InetMessagingAddress)dest);
                MessagingReporter msgReporter = this.receiver.getMessagingReporter();
                if (msgReporter != null) {
                    msgReporter.notifyStatCollectorOfMessageSent(dest, msg, buf.remaining());
                }
            }
        }
        catch (IOException e) {
            MessagingReporter msgReporter;
            if (dest != null && (msgReporter = this.receiver.getMessagingReporter()) != null) {
                msgReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw e;
        }
        return buf;
    }

    @Override
    public Message sendAndReceive(MessagingAddress dest, final Message msg) throws IOException {
        SocketAddress src;
        this.adjustLoopbackAddress((InetMessagingAddress)dest);
        Message ret = null;
        MessagingAddress selfAddress = this.receiver.getSelfAddress();
        if (dest.equals(selfAddress)) {
            ret = this.receiver.processMessage(msg);
            if (this.receiver.extMessageHandlerRegistered) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        UDPMessageSender.this.receiver.postProcessMessage(msg);
                    }
                };
                if (this.receiver.config.getUseThreadPool()) {
                    GlobalThreadPoolExecutors.getThreadPool(false, false, false).submit(r);
                } else {
                    Thread t = new Thread(r);
                    t.setName("TCPMessageSender: post-processing thread");
                    t.setDaemon(false);
                    t.start();
                }
            }
            return ret;
        }
        ByteBuffer buf = ByteBuffer.allocate(65536);
        DatagramChannel sock = !this.forReceiver ? this.receiver.sockPool.get() : this.receiver.sock;
        sock.configureBlocking(false);
        while ((src = sock.receive(buf)) != null) {
            buf.rewind();
            logger.info("Data have remained in TCP/IP protocol stack.");
        }
        sock.configureBlocking(true);
        long timeout = this.receiver.provider.getTimeoutCalculator().calculateTimeout(dest);
        long start = System.currentTimeMillis();
        this.send(sock, ((InetMessagingAddress)dest).getInetSocketAddress(), dest, msg, false);
        try {
            AlarmClock.setAlarm(timeout);
            sock.receive(buf);
            buf.rewind();
            ret = Message.decode(buf);
            AlarmClock.clearAlarm();
            this.receiver.provider.getTimeoutCalculator().updateRTT(dest, (int)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            Thread.interrupted();
            logger.info("Timeout: " + timeout + " msec.");
            MessagingReporter msgReporter = this.receiver.getMessagingReporter();
            if (msgReporter != null) {
                msgReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw new IOException("Timeout:" + timeout + " msec.");
        }
        if (!this.forReceiver) {
            this.receiver.sockPool.put(sock);
        }
        return ret;
    }

    private void adjustLoopbackAddress(InetMessagingAddress dest) {
        if (dest.getInetAddress().isLoopbackAddress()) {
            dest.setInetAddress(((InetMessagingAddress)this.receiver.getSelfAddress()).getInetAddress());
            logger.info("destination is loopback address and adjusted to " + dest);
        }
    }
}

