/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import ow.messaging.AbstractMessagingProvider;
import ow.messaging.InetMessagingAddress;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingProvider;
import ow.messaging.timeoutcalc.RTTBasedTimeoutCalculator;
import ow.messaging.timeoutcalc.StaticTimeoutCalculator;
import ow.messaging.timeoutcalc.TimeoutCalculator;
import ow.messaging.udp.UDPMessageReceiver;
import ow.messaging.udp.UDPMessagingConfiguration;

public class UDPMessagingProvider
extends AbstractMessagingProvider {
    private static final String NAME = "UDP";
    private final Map<Integer, UDPMessageReceiver> receiverTable = new HashMap<Integer, UDPMessageReceiver>();
    private InetAddress selfInetAddress = null;
    private TimeoutCalculator timeoutCalculator = null;
    private MessagingAddress statCollectorAddress = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isReliable() {
        return false;
    }

    @Override
    public MessagingConfiguration getDefaultConfiguration() {
        return new UDPMessagingConfiguration();
    }

    @Override
    public MessageReceiver getReceiver(MessagingConfiguration config, int port) throws IOException {
        return this.getReceiver(config, port, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReceiver getReceiver(MessagingConfiguration config, int port, int portRange) throws IOException {
        UDPMessageReceiver receiver;
        UDPMessagingProvider uDPMessagingProvider = this;
        synchronized (uDPMessagingProvider) {
            if (this.timeoutCalculator == null) {
                this.timeoutCalculator = config.getDoTimeoutCalculation() ? new RTTBasedTimeoutCalculator(config) : new StaticTimeoutCalculator(config);
            }
        }
        Map<Integer, UDPMessageReceiver> map = this.receiverTable;
        synchronized (map) {
            receiver = this.receiverTable.get(port);
            if (receiver == null) {
                receiver = new UDPMessageReceiver(this.selfInetAddress, port, portRange, (UDPMessagingConfiguration)config, this);
                this.receiverTable.put(receiver.getSelfAddress().getPort(), receiver);
                receiver.start();
            }
        }
        return receiver;
    }

    @Override
    public InetMessagingAddress getMessagingAddress(String hostname, int port) throws UnknownHostException {
        return new InetMessagingAddress(hostname, port);
    }

    @Override
    public InetMessagingAddress getMessagingAddress(String hostAndPort) throws UnknownHostException {
        return new InetMessagingAddress(hostAndPort);
    }

    protected InetMessagingAddress getMessagingAddress(InetSocketAddress inetSockAddress) {
        return new InetMessagingAddress(inetSockAddress);
    }

    @Override
    public InetMessagingAddress getMessagingAddress(int port) {
        return new InetMessagingAddress(port);
    }

    public TimeoutCalculator getTimeoutCalculator() {
        return this.timeoutCalculator;
    }

    @Override
    public MessagingAddress getMessagingCollectorAddress() {
        return this.statCollectorAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagingAddress setMessagingCollectorAddress(MessagingAddress addr) {
        MessagingAddress old;
        UDPMessagingProvider uDPMessagingProvider = this;
        synchronized (uDPMessagingProvider) {
            old = this.statCollectorAddress;
            this.statCollectorAddress = addr;
        }
        return old;
    }

    @Override
    public MessagingProvider substitute() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelfAddress(String host) throws UnknownHostException {
        this.selfInetAddress = InetAddress.getByName(host);
        Map<Integer, UDPMessageReceiver> map = this.receiverTable;
        synchronized (map) {
            for (UDPMessageReceiver receiver : this.receiverTable.values()) {
                receiver.setSelfAddress(host);
            }
        }
    }
}

