/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.upnp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.device.DeviceChangeListener;
import ow.messaging.upnp.Mapping;

public final class UPnPManager {
    public static Log logger = LogFactory.getLog(UPnPManager.class);
    private static final String ROUTER_DEV = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEV = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEV = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WANIPCON_SERV = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String WANPPPCON_SERV = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private static UPnPManager singletonInstance = new UPnPManager();
    private ControlPoint cp;
    private Device dev;
    private Service serv;
    private final Set<Mapping> registeredMappings = new HashSet<Mapping>();

    public static UPnPManager getInstance() {
        return singletonInstance;
    }

    public Device getDev() {
        return this.dev;
    }

    private UPnPManager() {
        this.cp = new ControlPoint();
    }

    public boolean start() {
        this.cp.addDeviceChangeListener((DeviceChangeListener)new DevChgListener());
        boolean ret = this.cp.start();
        logger.info("UPnP manager started.");
        return ret;
    }

    public void stop() {
        this.cp.stop();
    }

    public void waitForDeviceFound() {
        this.waitForDeviceFound(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForDeviceFound(long timeout) {
        UPnPManager uPnPManager = this;
        synchronized (uPnPManager) {
            block6: {
                if (!this.deviceFound()) break block6;
                return true;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.deviceFound();
    }

    private boolean deviceFound() {
        System.out.println("dev:" + this.dev + " serv:" + this.serv);
        return this.dev != null && this.serv != null;
    }

    public InetAddress getExternalAddress() {
        if (!this.deviceFound()) {
            return null;
        }
        Action a = this.serv.getAction("GetExternalIPAddress");
        if (a == null) {
            return null;
        }
        if (!a.postControlAction()) {
            return null;
        }
        Argument ipAddrArg = a.getOutputArgumentList().getArgument("NewExternalIPAddress");
        InetAddress ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(ipAddrArg.getValue());
        }
        catch (UnknownHostException e) {
            return null;
        }
        return ipAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMapping(Mapping map) {
        if (!this.deviceFound()) {
            return false;
        }
        Action a = this.serv.getAction("AddPortMapping");
        if (a == null) {
            return false;
        }
        a.setArgumentValue("NewRemoteHost", "");
        a.setArgumentValue("NewExternalPort", map.getExternalPort());
        a.setArgumentValue("NewInternalClient", map.getInternalAddress());
        a.setArgumentValue("NewInternalPort", map.getInternalPort());
        a.setArgumentValue("NewProtocol", map.getProtocol().toString());
        String desc = map.getDescription();
        if (desc != null) {
            a.setArgumentValue("NewPortMappingDescription", desc);
        }
        a.setArgumentValue("NewEnabled", "1");
        a.setArgumentValue("NewLeaseDuration", 0);
        boolean succeed = a.postControlAction();
        if (succeed) {
            Set<Mapping> set = this.registeredMappings;
            synchronized (set) {
                this.registeredMappings.add(map);
            }
        }
        logger.info("UPnP address port mapping " + (succeed ? "succeeded" : "failed") + ": ext port " + map.getExternalPort() + ", internal port " + map.getInternalPort());
        return succeed;
    }

    public boolean deleteMapping(int externalPort, Mapping.Protocol protocol) {
        Mapping map = new Mapping(externalPort, null, 0, protocol, null);
        return this.deleteMapping(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMapping(Mapping map) {
        if (!this.deviceFound()) {
            return false;
        }
        Action a = this.serv.getAction("DeletePortMapping");
        if (a == null) {
            return false;
        }
        a.setArgumentValue("NewRemoteHost", "");
        a.setArgumentValue("NewExternalPort", map.getExternalPort());
        a.setArgumentValue("NewProtocol", map.getProtocol().toString());
        boolean succeed = a.postControlAction();
        if (succeed) {
            Set<Mapping> set = this.registeredMappings;
            synchronized (set) {
                this.registeredMappings.remove(map);
            }
        }
        logger.info("UPnP address port mapping " + (succeed ? "deleted" : "deletion failed") + ": ext port " + map.getExternalPort());
        return succeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMapping() {
        Mapping[] maps;
        if (!this.deviceFound()) {
            return;
        }
        Set<Mapping> set = this.registeredMappings;
        synchronized (set) {
            int size = this.registeredMappings.size();
            if (size <= 0) {
                return;
            }
            maps = new Mapping[size];
            this.registeredMappings.toArray(maps);
        }
        Mapping[] mappingArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping m = mappingArray[n2];
            this.deleteMapping(m.getExternalPort(), m.getProtocol());
            ++n2;
        }
    }

    private class DevChgListener
    implements DeviceChangeListener {
        private DevChgListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceAdded(Device dev) {
            System.out.println("dev:" + dev);
            if (UPnPManager.this.deviceFound()) {
                return;
            }
            if (!dev.getDeviceType().equals(UPnPManager.ROUTER_DEV) || !dev.isRootDevice()) {
                return;
            }
            UPnPManager.this.dev = dev;
            for (Object o1 : dev.getDeviceList()) {
                Device d1 = (Device)o1;
                if (!d1.getDeviceType().equals(UPnPManager.WAN_DEV)) continue;
                for (Object o2 : d1.getDeviceList()) {
                    Device d2 = (Device)o2;
                    if (!d2.getDeviceType().equals(UPnPManager.WANCON_DEV)) continue;
                    UPnPManager.this.serv = d2.getService(UPnPManager.WANIPCON_SERV);
                    if (UPnPManager.this.serv == null) {
                        UPnPManager.this.serv = d2.getService(UPnPManager.WANPPPCON_SERV);
                    }
                    logger.info("UPnP device found: " + dev.getFriendlyName());
                    UPnPManager uPnPManager = UPnPManager.this;
                    synchronized (uPnPManager) {
                        UPnPManager.this.notifyAll();
                    }
                }
            }
        }

        public void deviceRemoved(Device dev) {
        }
    }
}

