/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import ow.messaging.util.AccessController;

public final class AccessControlledServerSocket
extends ServerSocket {
    private AccessController ac = null;

    public AccessControlledServerSocket(AccessController ac) throws IOException {
        this.ac = ac;
    }

    public AccessControlledServerSocket(AccessController ac, int port) throws IOException {
        super(port);
        this.ac = ac;
    }

    public AccessControlledServerSocket(AccessController ac, int port, int backlog) throws IOException {
        super(port, backlog);
        this.ac = ac;
    }

    public AccessControlledServerSocket(AccessController ac, int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
        this.ac = ac;
    }

    public AccessControlledServerSocket() throws IOException {
    }

    public AccessControlledServerSocket(int port) throws IOException {
        super(port);
    }

    public AccessControlledServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public AccessControlledServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessController(AccessController ac) {
        AccessControlledServerSocket accessControlledServerSocket = this;
        synchronized (accessControlledServerSocket) {
            this.ac = ac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        AccessController localAC;
        Socket sock = super.accept();
        AccessControlledServerSocket accessControlledServerSocket = this;
        synchronized (accessControlledServerSocket) {
            localAC = this.ac;
        }
        if (localAC != null && !localAC.allow(sock.getInetAddress())) {
            sock.close();
        }
        return sock;
    }
}

