/*
 * Decompiled with CFR 0.152.
 */
package ow.routing;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.chord.ChordProvider;
import ow.routing.kademlia.KademliaProvider;
import ow.routing.koorde.KoordeProvider;
import ow.routing.linearwalker.LinearWalkerProvider;
import ow.routing.pastry.PastryProvider;
import ow.routing.tapestry.TapestryProvider;

public class RoutingAlgorithmFactory {
    public static Log logger = LogFactory.getLog(RoutingAlgorithmFactory.class);
    private static final Class[] PROVIDERS = new Class[]{ChordProvider.class, KademliaProvider.class, KoordeProvider.class, LinearWalkerProvider.class, PastryProvider.class, TapestryProvider.class};
    private static final Map<String, RoutingAlgorithmProvider> providerTable = new HashMap<String, RoutingAlgorithmProvider>();
    private static final Map<String, Integer> idTable = new HashMap<String, Integer>();

    static {
        int id = 1;
        Class[] classArray = PROVIDERS;
        int n = PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Object o;
                Class clazz = classArray[n2];
                try {
                    o = clazz.newInstance();
                }
                catch (Exception e) {
                    logger.warn("Could not instantiate an object of the class: " + clazz, e);
                    break block4;
                }
                if (o instanceof RoutingAlgorithmProvider) {
                    RoutingAlgorithmProvider provider = (RoutingAlgorithmProvider)o;
                    providerTable.put(provider.getName(), provider);
                    idTable.put(provider.getName(), id);
                    ++id;
                }
            }
            ++n2;
        }
    }

    public static RoutingAlgorithmProvider getProvider(String algorithmName) throws NoSuchProviderException {
        RoutingAlgorithmProvider provider = providerTable.get(algorithmName);
        if (provider == null) {
            throw new NoSuchProviderException("No such algorithm: " + algorithmName);
        }
        return provider;
    }

    public static byte getAlgorithmID(String algorithmName) throws NoSuchProviderException {
        Integer idInteger = idTable.get(algorithmName);
        if (idInteger == null && idInteger == null) {
            throw new NoSuchProviderException("No such algorithm: " + algorithmName);
        }
        return (byte)idInteger.intValue();
    }
}

