/*
 * Decompiled with CFR 0.152.
 */
package ow.routing;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.routing.RoutingServiceProvider;
import ow.routing.impl.IterativeRoutingDriverProvider;
import ow.routing.impl.RecursiveRoutingDriverProvider;

public class RoutingServiceFactory {
    public static Log logger = LogFactory.getLog(RoutingServiceFactory.class);
    private static final Class[] PROVIDERS = new Class[]{IterativeRoutingDriverProvider.class, RecursiveRoutingDriverProvider.class};
    private static final Map<String, RoutingServiceProvider> providerTable = new HashMap<String, RoutingServiceProvider>();
    private static final Map<String, Integer> idTable = new HashMap<String, Integer>();

    static {
        int id = 1;
        Class[] classArray = PROVIDERS;
        int n = PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Object o;
                Class clazz = classArray[n2];
                try {
                    o = clazz.newInstance();
                }
                catch (Exception e) {
                    logger.warn("Could not instantiate an object of the class: " + clazz, e);
                    break block4;
                }
                if (o instanceof RoutingServiceProvider) {
                    RoutingServiceProvider provider = (RoutingServiceProvider)o;
                    idTable.put(provider.getName(), id);
                    ++id;
                    providerTable.put(provider.getName(), provider);
                }
            }
            ++n2;
        }
    }

    public static RoutingServiceProvider getProvider(String routingStyle) throws NoSuchProviderException {
        RoutingServiceProvider provider = providerTable.get(routingStyle);
        if (provider == null) {
            throw new NoSuchProviderException("No such routing style: " + routingStyle);
        }
        return provider;
    }

    public static byte getRoutingStyleID(String routingStyle) throws NoSuchProviderException {
        Integer idInteger = idTable.get(routingStyle);
        if (idInteger == null) {
            throw new NoSuchProviderException("No such routing style: " + routingStyle);
        }
        return (byte)idInteger.intValue();
    }
}

