/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.chord;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.chord.AbstractChord;
import ow.routing.chord.ChordConfiguration;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.util.Timer;

public final class Chord
extends AbstractChord {
    public static Log logger = LogFactory.getLog(Chord.class);
    private ChordConfiguration config;
    private FingerTableFixer fingerTableFixer;
    private Thread fingerTableFixerThread = null;

    protected Chord(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (ChordConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not ChordConfiguration.");
        }
    }

    private synchronized void startFingerTableFixer() {
        if (!this.config.getDoFixFingers()) {
            return;
        }
        if (this.fingerTableFixer != null) {
            return;
        }
        this.fingerTableFixer = new FingerTableFixer();
        if (this.config.getUseTimerInsteadOfThread()) {
            timer.schedule(this.fingerTableFixer, System.currentTimeMillis(), true, true);
        } else if (this.fingerTableFixerThread == null) {
            this.fingerTableFixerThread = new Thread(this.fingerTableFixer);
            this.fingerTableFixerThread.setName("FingerTableFixer on " + this.selfIDAddress.getAddress());
            this.fingerTableFixerThread.setDaemon(true);
            this.fingerTableFixerThread.start();
        }
    }

    private synchronized void stopFingerTableFixer() {
        if (this.fingerTableFixerThread != null) {
            this.fingerTableFixerThread.interrupt();
            this.fingerTableFixerThread = null;
        }
    }

    @Override
    public synchronized void stop() {
        logger.info("Chord#stop() called.");
        super.stop();
        this.stopFingerTableFixer();
    }

    @Override
    public synchronized void suspend() {
        super.suspend();
        this.stopFingerTableFixer();
    }

    @Override
    public synchronized void resume() {
        super.resume();
        this.startFingerTableFixer();
    }

    @Override
    public void prepareHandlers() {
        super.prepareHandlers(true);
        ReqConnectMessageHandler handler = new ReqConnectMessageHandler();
        this.runtime.addMessageHandler(Tag.REQ_CONNECT.getNumber(), handler);
    }

    static /* synthetic */ Random access$5() {
        return AbstractRoutingAlgorithm.random;
    }

    static /* synthetic */ Timer access$10() {
        return AbstractRoutingAlgorithm.timer;
    }

    private final class FingerTableFixer
    implements Runnable {
        public static final boolean OPTIMIZE = false;

        private FingerTableFixer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                boolean updated = true;
                try {
                    if (!Chord.this.config.getUseTimerInsteadOfThread()) {
                        Thread.sleep(Chord.this.config.getFixFingersInitialInterval());
                    }
                    do {
                        BigInteger fingerEdgeDistance;
                        Chord chord = Chord.this;
                        synchronized (chord) {
                            if (Chord.this.stopped || Chord.this.suspended) {
                                Chord.this.fingerTableFixer = null;
                                Chord.this.fingerTableFixerThread = null;
                                break block14;
                            }
                        }
                        if (Chord.access$5().nextDouble() < Chord.this.config.getProbProportionalToIDSpace()) {
                            fingerEdgeDistance = new BigInteger(Chord.this.idSizeInBit - 1, Chord.access$5());
                        } else {
                            int i = Chord.access$5().nextInt(Chord.this.idSizeInBit - 1) + 2;
                            fingerEdgeDistance = BigInteger.ONE.shiftLeft(i - 1);
                        }
                        BigInteger fingerStartBigInteger = Chord.this.selfIDAddress.getID().toBigInteger().add(fingerEdgeDistance);
                        ID fingerEdge = ID.getID(fingerStartBigInteger, Chord.this.config.getIDSizeInByte());
                        try {
                            RoutingResult res = Chord.this.runtime.routeToRootNode(fingerEdge, 1);
                            RoutingHop[] route = res.getRoute();
                            IDAddressPair rootNode = route[route.length - 1].getIDAddressPair();
                            int i = route.length - 1;
                            while (i > 0) {
                                IDAddressPair node = route[i].getIDAddressPair();
                                if (!Chord.this.selfIDAddress.getID().equals(node.getID())) {
                                    updated |= Chord.this.fingerTable.put(node);
                                    Chord.this.successorList.add(node);
                                }
                                --i;
                            }
                            if (!updated) continue;
                            logger.info("An entry incorporated to finger table: " + rootNode);
                        }
                        catch (RoutingException e) {
                            logger.warn("Routing failed.", e);
                        }
                    } while (!this.sleep());
                    return;
                }
                catch (InterruptedException e) {
                    logger.warn("FingerTableFixer interrupted and die.", e);
                }
            }
        }

        private boolean sleep() throws InterruptedException {
            long interval = Chord.this.config.getFixFingersMinInterval();
            long minInterval = Chord.this.config.getFixFingersMinInterval();
            long maxInterval = Chord.this.config.getFixFingersMaxInterval();
            int numFingers = Chord.this.fingerTable.numOfDifferentEntries();
            double ratio = Math.log(numFingers + 1) / Math.log(Chord.this.idSizeInBit + 1);
            interval = minInterval + (long)((double)(maxInterval - minInterval) * ratio);
            double playRatio = Chord.this.config.getFixFingersIntervalPlayRatio();
            double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * Chord.access$5().nextDouble();
            long sleepPeriod = (long)((double)interval * intervalRatio);
            if (Chord.this.config.getUseTimerInsteadOfThread()) {
                Chord.access$10().schedule(this, System.currentTimeMillis() + sleepPeriod, true, true);
                return true;
            }
            Thread.sleep(sleepPeriod);
            return false;
        }
    }

    class ReqConnectMessageHandler
    extends AbstractChord.ReqConnectMessageHandler {
        ReqConnectMessageHandler() {
        }
    }
}

