/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.chord;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.chord.AbstractChord;
import ow.routing.chord.ChordMessageFactory;

public final class ChordInAggressiveJoiningMode
extends AbstractChord {
    public static Log logger = LogFactory.getLog(ChordInAggressiveJoiningMode.class);
    private final Message ackFingerTableMessage;

    protected ChordInAggressiveJoiningMode(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        this.ackFingerTableMessage = ChordMessageFactory.getAckFingerTableMessage(this.selfIDAddress);
    }

    @Override
    public void join(IDAddressPair[] neighbors) {
        IDAddressPair rootNode = neighbors[0];
        super.join(neighbors);
        IDAddressPair rootNodeOfFingerEnd = rootNode;
        BigInteger rootNodeDistance = this.distance(rootNodeOfFingerEnd.getID(), this.selfIDAddress.getID());
        this.fingerTable.set(1, rootNodeOfFingerEnd);
        this.successorList.add(rootNodeOfFingerEnd);
        logger.info("join() performs \"init_finger_table()\".");
        logger.info("i=1: " + rootNodeOfFingerEnd.getAddress());
        int i = 2;
        while (i <= this.idSizeInBit) {
            BigInteger fingerEndDistance = BigInteger.ONE.shiftLeft(i - 1);
            if (rootNodeDistance.compareTo(fingerEndDistance) < 0) {
                BigInteger fingerEndIDValue = this.selfIDAddress.getID().toBigInteger().add(fingerEndDistance);
                ID fingerEndID = ID.getID(fingerEndIDValue, this.config.getIDSizeInByte());
                try {
                    RoutingResult res = this.runtime.routeToRootNode(fingerEndID, 1);
                    RoutingHop[] routeToFingerEnd = res.getRoute();
                    rootNodeOfFingerEnd = routeToFingerEnd[routeToFingerEnd.length - 1].getIDAddressPair();
                    rootNodeDistance = this.distance(rootNodeOfFingerEnd.getID(), this.selfIDAddress.getID());
                    logger.info("i=" + i + ": " + rootNodeOfFingerEnd.getAddress());
                }
                catch (RoutingException e) {
                    logger.warn("Routing failed.", e);
                }
            }
            this.fingerTable.set(i, rootNodeOfFingerEnd);
            this.successorList.add(rootNodeOfFingerEnd);
            ++i;
        }
        logger.info("join() performs \"update_others()\".");
        BigInteger selfIDBigInteger = this.selfIDAddress.getID().toBigInteger();
        IDAddressPair lastTarget = null;
        int i2 = 1;
        while (i2 <= this.idSizeInBit) {
            block10: {
                RoutingResult res;
                BigInteger targetIDBigInteger = selfIDBigInteger.subtract(BigInteger.ONE.shiftLeft(i2 - 1).subtract(BigInteger.ONE));
                ID targetID = ID.getID(targetIDBigInteger, this.config.getIDSizeInByte());
                try {
                    res = this.runtime.routeToClosestNode(targetID, 1);
                }
                catch (RoutingException e) {
                    logger.warn("Routing failed.", e);
                    break block10;
                }
                RoutingHop[] route = res.getRoute();
                IDAddressPair predecessorOfTarget = route[route.length - 1].getIDAddressPair();
                if (!predecessorOfTarget.equals(lastTarget)) {
                    if (i2 > 2 && !this.selfIDAddress.equals(lastTarget)) {
                        this.sendUpdateFingerTableMessage(lastTarget, i2 - 1);
                    }
                    lastTarget = predecessorOfTarget;
                }
            }
            ++i2;
        }
        if (!this.selfIDAddress.equals(lastTarget)) {
            this.sendUpdateFingerTableMessage(lastTarget, this.idSizeInBit);
        }
        logger.info("join() completed.");
    }

    private void sendUpdateFingerTableMessage(IDAddressPair target, int largestIndex) {
        Message reqMsg = ChordMessageFactory.getUpdateFingerTableMessage(this.selfIDAddress, largestIndex);
        try {
            Message repMsg = this.sender.sendAndReceive(target.getAddress(), reqMsg);
            if (repMsg.getTag() != Tag.ACK_FINGER_TABLE.getNumber()) {
                logger.fatal("A reply to an UPDATE_FINGER_TABLE message is not an ACK_FINGER_TABLE.");
            }
        }
        catch (IOException e) {
            logger.warn("Failed to send an UPDATE_FINGER_TABLE request or receive a reply.", e);
            this.fail(target);
        }
    }

    @Override
    public void forget(IDAddressPair failedNode) {
        IDAddressPair newSuccessor;
        IDAddressPair oldSuccessor = this.successorList.first();
        super.forget(failedNode);
        try {
            newSuccessor = this.successorList.first();
        }
        catch (NoSuchElementException e) {
            return;
        }
        if (!newSuccessor.equals(oldSuccessor)) {
            boolean succeed = false;
            do {
                try {
                    IDAddressPair predOfSucc;
                    this.predecessor = predOfSucc = super.connectToSuccessor(newSuccessor, true);
                    succeed = true;
                }
                catch (IOException e0) {
                    this.successorList.remove(newSuccessor);
                    try {
                        newSuccessor = this.successorList.first();
                    }
                    catch (NoSuchElementException e1) {
                        return;
                    }
                }
            } while (!succeed);
        }
    }

    @Override
    public void prepareHandlers() {
        super.prepareHandlers(true);
        MessageHandler handler = new ReqConnectMessageHandler(this.towardSelfComparator);
        this.runtime.addMessageHandler(Tag.REQ_CONNECT.getNumber(), handler);
        handler = new MessageHandler(){

            @Override
            public Message process(final Message msg) {
                ChordInAggressiveJoiningMode.this.algorithm.touch(msg.getSource());
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        BigInteger distanceOfExisting;
                        Serializable[] contents = msg.getContents();
                        int largestIndex = (Integer)contents[0];
                        IDAddressPair candidateNode = msg.getSource();
                        IDAddressPair existingNode = (this).ChordInAggressiveJoiningMode.this.fingerTable.get(largestIndex);
                        BigInteger distanceOfCandidate = ChordInAggressiveJoiningMode.this.distance(candidateNode.getID(), ChordInAggressiveJoiningMode.this.selfIDAddress.getID());
                        if (distanceOfCandidate.compareTo(distanceOfExisting = ChordInAggressiveJoiningMode.this.distance(existingNode.getID(), ChordInAggressiveJoiningMode.this.selfIDAddress.getID())) < 0) {
                            (this).ChordInAggressiveJoiningMode.this.fingerTable.put(candidateNode, largestIndex);
                            ChordInAggressiveJoiningMode.this.successorList.add(candidateNode);
                            if (!ChordInAggressiveJoiningMode.this.predecessor.equals(candidateNode)) {
                                try {
                                    Message repMsg = ChordInAggressiveJoiningMode.this.sender.sendAndReceive(ChordInAggressiveJoiningMode.this.predecessor.getAddress(), msg);
                                    if (repMsg.getTag() != Tag.ACK_FINGER_TABLE.getNumber()) {
                                        logger.fatal("A reply to an UPDATE_FINGER_TABLE message is not an ACK.");
                                    }
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to send an <NGER_TABLE request or receive a reply.", e);
                                    ChordInAggressiveJoiningMode.this.fail(ChordInAggressiveJoiningMode.this.predecessor);
                                }
                            }
                        }
                    }
                };
                Thread t = new Thread(r);
                t.setName("A MessageHandler of Chord");
                t.setDaemon(true);
                t.setPriority(Thread.currentThread().getPriority() - 1);
                t.start();
                return ChordInAggressiveJoiningMode.this.ackFingerTableMessage;
            }
        };
        this.runtime.addMessageHandler(Tag.UPDATE_FINGER_TABLE.getNumber(), handler);
    }

    class ReqConnectMessageHandler
    extends AbstractChord.ReqConnectMessageHandler {
        ReqConnectMessageHandler(Comparator<IDAddressPair> comparator) {
        }

        @Override
        public Message process(Message msg) {
            Message repMsg = super.process(msg);
            ChordInAggressiveJoiningMode.this.predecessor = msg.getSource();
            return repMsg;
        }
    }
}

