/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.chord;

import java.security.InvalidAlgorithmParameterException;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingService;
import ow.routing.chord.AbstractChord;
import ow.routing.chord.Chord;
import ow.routing.chord.ChordConfiguration;
import ow.routing.chord.ChordInAggressiveJoiningMode;

public class ChordProvider
implements RoutingAlgorithmProvider {
    private static final String ALGORITHM_NAME = "Chord";

    @Override
    public String getName() {
        return ALGORITHM_NAME;
    }

    @Override
    public RoutingAlgorithmConfiguration getDefaultConfiguration() {
        return new ChordConfiguration();
    }

    @Override
    public RoutingAlgorithm initializeAlgorithmInstance(RoutingAlgorithmConfiguration conf, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        boolean aggressiveJoiningMode = ((ChordConfiguration)conf).getAggressiveJoiningMode();
        AbstractChord algo = aggressiveJoiningMode ? new ChordInAggressiveJoiningMode(conf, routingSvc) : new Chord(conf, routingSvc);
        return algo;
    }
}

