/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.chord;

import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.routing.RoutingAlgorithm;

public final class FingerTable {
    public static Log logger = LogFactory.getLog(FingerTable.class);
    private final int idSizeInBit;
    private final IDAddressPair[] fingerTable;
    private final RoutingAlgorithm algorithm;
    private final IDAddressPair selfIDAddressPair;
    private final boolean aggressiveJoining;

    public FingerTable(int idSizeInByte, RoutingAlgorithm algorithm, IDAddressPair selfIDAddressPair, boolean aggressiveJoining) {
        this.idSizeInBit = idSizeInByte * 8;
        this.fingerTable = new IDAddressPair[this.idSizeInBit + 1];
        this.algorithm = algorithm;
        this.selfIDAddressPair = selfIDAddressPair;
        this.aggressiveJoining = aggressiveJoining;
        this.clear();
    }

    synchronized void clear() {
        int i = 0;
        while (i < this.idSizeInBit + 1) {
            this.fingerTable[i] = this.selfIDAddressPair;
            ++i;
        }
    }

    public IDAddressPair get(int k) {
        return this.fingerTable[k];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair set(int k, IDAddressPair entry) {
        IDAddressPair old;
        FingerTable fingerTable = this;
        synchronized (fingerTable) {
            old = this.fingerTable[k];
            this.fingerTable[k] = entry;
        }
        return old;
    }

    public boolean put(IDAddressPair newEntry) {
        ID newID = newEntry.getID();
        ID selfID = this.selfIDAddressPair.getID();
        BigInteger distanceOfNewEntry = this.algorithm.distance(newID, selfID);
        int largestIndex = distanceOfNewEntry.bitLength();
        return this.put(newEntry, largestIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(IDAddressPair newEntry, int largestIndex) {
        boolean updated = false;
        FingerTable fingerTable = this;
        synchronized (fingerTable) {
            int i = largestIndex;
            while (i > 0) {
                IDAddressPair existingEntry = this.fingerTable[i];
                if (!this.algorithm.toReplace(existingEntry, newEntry)) {
                    if (this.aggressiveJoining) {
                        break;
                    }
                } else {
                    this.fingerTable[i] = newEntry;
                    updated = true;
                }
                --i;
            }
            if (updated) {
                logger.info("FingerTable#put: " + newEntry + " from " + largestIndex + " to " + (i + 1));
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ID target) {
        BigInteger distance = this.algorithm.distance(target, this.selfIDAddressPair.getID());
        int possibleLargestIndex = distance.bitLength();
        if (possibleLargestIndex > this.idSizeInBit) {
            return;
        }
        logger.info("FingerTable#remove: " + target);
        FingerTable fingerTable = this;
        synchronized (fingerTable) {
            IDAddressPair altEntry;
            try {
                altEntry = this.fingerTable[possibleLargestIndex + 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                altEntry = this.selfIDAddressPair;
            }
            int i = possibleLargestIndex;
            while (i > 0) {
                if (this.fingerTable[i].getID().equals(target)) {
                    this.fingerTable[i] = altEntry;
                } else if (this.aggressiveJoining) break;
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numOfDifferentEntries() {
        int count = 0;
        IDAddressPair lastEntry = this.selfIDAddressPair;
        IDAddressPair[] iDAddressPairArray = this.fingerTable;
        synchronized (this.fingerTable) {
            int i = this.idSizeInBit;
            while (i >= 1) {
                if (!lastEntry.equals(this.fingerTable[i])) {
                    lastEntry = this.fingerTable[i];
                    ++count;
                }
                --i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return count;
        }
    }
}

