/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessageSender;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingRuntime;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.AbstractRoutingDriver;
import ow.util.Timer;

public abstract class AbstractRoutingAlgorithm
implements RoutingAlgorithm {
    public static Log logger = LogFactory.getLog(AbstractRoutingAlgorithm.class);
    protected static final Random random = new Random();
    protected static Timer timer = null;
    protected IDAddressPair selfIDAddress;
    protected final RoutingAlgorithmConfiguration config;
    protected final RoutingRuntime runtime;
    protected RoutingServiceConfiguration runtimeConfig;
    protected MessageSender sender;
    private final FailureTable failureTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractRoutingAlgorithm(RoutingAlgorithmConfiguration config, RoutingService routingSvc) {
        this.config = config;
        this.runtime = (RoutingRuntime)((Object)routingSvc);
        if (routingSvc != null) {
            this.runtimeConfig = this.runtime.getConfiguration();
            this.sender = this.runtime.getMessageSender();
            this.selfIDAddress = routingSvc.getSelfIDAddressPair();
            try {
                ((AbstractRoutingDriver)routingSvc).setRoutingAlgorithm(this);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.failureTable = new FailureTable(this.config.getFailureExpiration());
        if (!config.getUseTimerInsteadOfThread()) return;
        Class<AbstractRoutingAlgorithm> clazz = AbstractRoutingAlgorithm.class;
        synchronized (AbstractRoutingAlgorithm.class) {
            if (timer != null) return;
            timer = new Timer("A Timer in RoutingAlgorithm", true, 5);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public RoutingContext initialRoutingContext(ID target) {
        return null;
    }

    @Override
    public final void fail(IDAddressPair failedNode) {
        int numOfFailures = this.failureTable.register(failedNode);
        String additionalMsg = "";
        if (numOfFailures >= this.config.getNumOfFailuresBeforeForgetNode()) {
            this.forget(failedNode);
            additionalMsg = ", and forget it";
        }
        logger.warn("RoutingAlgorithm#fail: " + failedNode.getAddress() + " on " + this.selfIDAddress.getAddress() + " " + numOfFailures + " time" + (numOfFailures > 1 ? "s" : "") + additionalMsg + ".");
    }

    @Override
    public final RoutingAlgorithmConfiguration getConfiguration() {
        return this.config;
    }

    private static final class FailureTable {
        private static final int GC_FREQ = 100;
        private int gcCountdown = 100;
        private long expiration;
        private Map<IDAddressPair, Long> lastFailedTimeTable;
        private Map<IDAddressPair, Integer> numOfTimesTable;

        FailureTable(long expiration) {
            this.expiration = expiration;
            this.numOfTimesTable = new HashMap<IDAddressPair, Integer>();
            this.lastFailedTimeTable = new HashMap<IDAddressPair, Long>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int register(IDAddressPair node) {
            int numOfTimes;
            long currentTime = System.currentTimeMillis();
            FailureTable failureTable = this;
            synchronized (failureTable) {
                Long lastTimeObj = this.lastFailedTimeTable.get(node);
                long lastTime = lastTimeObj == null ? 0L : lastTimeObj;
                Integer numOfTimesObj = this.numOfTimesTable.get(node);
                int n = numOfTimes = numOfTimesObj == null ? 0 : numOfTimesObj;
                if (currentTime >= lastTime + this.expiration) {
                    numOfTimes = 0;
                }
                this.lastFailedTimeTable.put(node, currentTime);
                this.numOfTimesTable.put(node, ++numOfTimes);
                if (--this.gcCountdown <= 0) {
                    this.gcCountdown = 100;
                    Set<Map.Entry<IDAddressPair, Long>> entrySet = this.lastFailedTimeTable.entrySet();
                    Map.Entry[] entryArray = new Map.Entry[entrySet.size()];
                    entrySet.toArray(entryArray);
                    Map.Entry[] entryArray2 = entryArray;
                    int n2 = entryArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Map.Entry e = entryArray2[n3];
                        lastTime = (Long)e.getValue();
                        if (currentTime >= lastTime + this.expiration) {
                            IDAddressPair idAddr = (IDAddressPair)e.getKey();
                            this.lastFailedTimeTable.remove(idAddr);
                            this.numOfTimesTable.remove(idAddr);
                        }
                        ++n3;
                    }
                }
            }
            return numOfTimes;
        }
    }
}

