/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.koorde;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.IDAddressRoutingContextTriplet;
import ow.id.comparator.AlgoBasedFromSrcIDComparator;
import ow.id.comparator.AlgoBasedTowardTargetIDComparator;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.koorde.KoordeConfiguration;
import ow.routing.koorde.KoordeMessageFactory;
import ow.routing.koorde.KoordeRoutingContext;
import ow.routing.linearwalker.LinearWalker;
import ow.util.HTMLUtil;
import ow.util.Timer;

public final class Koorde
extends LinearWalker {
    public static Log logger = LogFactory.getLog(Koorde.class);
    private final Message reqPredecessorMessage;
    private KoordeConfiguration config;
    private final int digitBits;
    private ID km;
    private IDAddressPair[] edges;
    private int numEdges;
    private EdgeFixer edgeFixer = null;
    private Thread edgeFixerThread = null;

    protected Koorde(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (KoordeConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not KoordeConfiguration.");
        }
        this.digitBits = this.config.getDigitBits();
        this.km = this.selfIDAddress.getID().shiftLeft(this.digitBits);
        this.numEdges = this.config.getNumEdges();
        this.edges = new IDAddressPair[this.numEdges];
        this.reqPredecessorMessage = KoordeMessageFactory.getReqPredecessorMessage(this.selfIDAddress);
    }

    private synchronized void startEdgeFixer() {
        if (this.edgeFixer != null) {
            return;
        }
        this.edgeFixer = new EdgeFixer(this.config, this.km);
        if (this.config.getUseTimerInsteadOfThread()) {
            timer.schedule(this.edgeFixer, System.currentTimeMillis(), true, true);
        } else if (this.edgeFixerThread == null) {
            this.edgeFixerThread = new Thread(this.edgeFixer);
            this.edgeFixerThread.setName("EdgeFixer on " + this.selfIDAddress.getAddress());
            this.edgeFixerThread.setDaemon(true);
            this.edgeFixerThread.start();
        }
    }

    private synchronized void stopEdgeFixer() {
        if (this.edgeFixer != null) {
            this.edgeFixer = null;
        }
        if (this.edgeFixerThread != null) {
            this.edgeFixerThread.interrupt();
            this.edgeFixerThread = null;
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.edges = new IDAddressPair[this.config.getNumEdges()];
    }

    @Override
    public synchronized void stop() {
        logger.info("Koorde#stop() called.");
        super.stop();
        this.stopEdgeFixer();
    }

    @Override
    public synchronized void suspend() {
        super.suspend();
        this.stopEdgeFixer();
    }

    @Override
    public synchronized void resume() {
        super.resume();
        this.startEdgeFixer();
    }

    @Override
    public RoutingContext initialRoutingContext(ID targetID) {
        int idSize = this.config.getIDSizeInByte();
        ID selfID = this.selfIDAddress.getID();
        ID successor = this.successorList.first().getID();
        BigInteger selfIDInteger = selfID.toBigInteger();
        BigInteger successorInteger = successor.toBigInteger();
        BigInteger targetIDInteger = targetID.toBigInteger();
        if (this.selfIDAddress.getID().equals(successor)) {
            return new KoordeRoutingContext(targetID, selfID, this.digitBits);
        }
        AlgoBasedFromSrcIDComparator fromSelfComparator = new AlgoBasedFromSrcIDComparator(this, selfID);
        int i = 0;
        i = 0;
        while (i < this.idSizeInBit) {
            if (selfIDInteger.testBit(this.idSizeInBit - 1 - i) != successorInteger.testBit(this.idSizeInBit - 1 - i)) break;
            ++i;
        }
        i /= this.digitBits;
        int iter = (this.idSizeInBit - 1) / this.digitBits + 1;
        while (i <= iter) {
            int shiftWidth = this.idSizeInBit - this.digitBits * i;
            BigInteger mask = BigInteger.ONE.shiftLeft(shiftWidth).subtract(BigInteger.ONE);
            BigInteger topBitsOfK = targetIDInteger.shiftRight(this.digitBits * i);
            BigInteger baseID = selfIDInteger;
            ID imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            baseID = successorInteger;
            imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            baseID = selfIDInteger.add(BigInteger.ONE.shiftLeft(shiftWidth));
            imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            baseID = successorInteger.subtract(BigInteger.ONE.shiftLeft(shiftWidth));
            imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            ++i;
        }
        return new KoordeRoutingContext(targetID, selfID, this.digitBits);
    }

    @Override
    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        AlgoBasedFromSrcIDComparator fromSelfComparator;
        KoordeRoutingContext context = (KoordeRoutingContext)cxt;
        ID succ = this.successorList.first().getID();
        ID i = context.getI();
        ID selfID = this.selfIDAddress.getID();
        AlgoBasedTowardTargetIDComparator toSuccComparator = new AlgoBasedTowardTargetIDComparator(this, succ);
        if (target.equals(succ) || toSuccComparator.compare(selfID, target) > 0) {
            IDAddressPair[] ret;
            if (this.predecessor != null && !this.predecessor.equals(this.selfIDAddress)) {
                ret = new IDAddressRoutingContextTriplet[2];
                ret[1] = new IDAddressRoutingContextTriplet(this.predecessor, context);
            } else {
                ret = new IDAddressRoutingContextTriplet[]{new IDAddressRoutingContextTriplet(this.selfIDAddress, context)};
            }
            return ret;
        }
        if (i.equals(succ) || toSuccComparator.compare(selfID, i) > 0) {
            if (this.edges[0] != null) {
                RoutingContext updatedContext = context.next();
                IDAddressPair[] ret = new IDAddressRoutingContextTriplet[this.edges.length];
                int j = 0;
                while (j < this.edges.length) {
                    if (this.edges[j] != null) {
                        ret[j] = new IDAddressRoutingContextTriplet(this.edges[j], updatedContext);
                    }
                    ++j;
                }
                return ret;
            }
            context = null;
        }
        ID cutPoint = (fromSelfComparator = new AlgoBasedFromSrcIDComparator(this, selfID)).compare(target, i) < 0 ? target : i;
        IDAddressPair[] succList = this.successorList.closestNodes(cutPoint, false);
        IDAddressPair[] ret = new IDAddressRoutingContextTriplet[succList.length];
        int j = 0;
        while (j < succList.length) {
            ret[j] = new IDAddressRoutingContextTriplet(succList[j], context);
            ++j;
        }
        return ret;
    }

    @Override
    public void forget(IDAddressPair failedNode) {
        super.forget(failedNode);
        this.forget(this.edges, failedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forget(IDAddressPair[] edges, IDAddressPair failedNode) {
        IDAddressPair[] iDAddressPairArray = this.edges;
        synchronized (this.edges) {
            int nEdges = this.edges.length;
            int i = 0;
            while (i < nEdges) {
                if (failedNode.equals(this.edges[i])) {
                    int j = i;
                    j = i;
                    while (j < i - 1) {
                        this.edges[j] = this.edges[j + 1];
                        ++j;
                    }
                    this.edges[j] = null;
                }
                ++i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getRoutingTableString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getRoutingTableString(verboseLevel));
        sb.append("\n");
        sb.append(String.valueOf(1 << this.digitBits) + "m: ");
        sb.append(this.km.toString(verboseLevel));
        sb.append("\n");
        sb.append("de Bruijn edge and backups: [");
        int i = 0;
        while (i < this.config.getNumEdges()) {
            if (this.edges[i] == null) break;
            sb.append("\n ");
            sb.append(this.edges[i].toString(verboseLevel));
            ++i;
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getRoutingTableHTMLString());
        sb.append("<h4>" + HTMLUtil.stringInHTML(Integer.toString(1 << this.digitBits)) + "m</h4>\n");
        sb.append(String.valueOf(HTMLUtil.stringInHTML(this.km.toString())) + "\n");
        sb.append("<h4>De Bruijn edges and backups</h4>\n");
        int i = 0;
        while (i < this.config.getNumEdges()) {
            if (this.edges[i] == null) break;
            String url = HTMLUtil.convertMessagingAddressToURL(this.edges[i].getAddress());
            sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a><br>\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void prepareHandlers() {
        super.prepareHandlers();
        MessageHandler handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                return KoordeMessageFactory.getRepPredecessorMessage(Koorde.this.selfIDAddress, Koorde.this.predecessor);
            }
        };
        this.runtime.addMessageHandler(Tag.REQ_PREDECESSOR.getNumber(), handler);
    }

    static /* synthetic */ Random access$12() {
        return AbstractRoutingAlgorithm.random;
    }

    static /* synthetic */ Timer access$13() {
        return AbstractRoutingAlgorithm.timer;
    }

    private class EdgeFixer
    implements Runnable {
        private long interval;
        private ID km;

        EdgeFixer(KoordeConfiguration config, ID km) {
            this.interval = Koorde.this.config.getFixEdgeMinInterval();
            this.km = km;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block22: {
                try {
                    boolean backupsToBeUpdated;
                    do {
                        Koorde koorde = Koorde.this;
                        synchronized (koorde) {
                            if (Koorde.this.stopped || Koorde.this.suspended) {
                                Koorde.this.edgeFixer = null;
                                Koorde.this.edgeFixerThread = null;
                                break block22;
                            }
                        }
                        backupsToBeUpdated = true;
                        try {
                            RoutingResult res = Koorde.this.runtime.routeToClosestNode(this.km, 1);
                            RoutingHop[] route = res.getRoute();
                            IDAddressPair oldEdge = Koorde.this.edges[0];
                            try {
                                ((Koorde)Koorde.this).edges[0] = ((IDAddressRoutingContextTriplet)route[route.length - 1].getIDAddressPair()).getIDAddressPair();
                            }
                            catch (ClassCastException e) {
                                ((Koorde)Koorde.this).edges[0] = route[route.length - 1].getIDAddressPair();
                            }
                            int nEdges = Koorde.this.edges.length;
                            boolean bl = backupsToBeUpdated = Koorde.this.edges[0] != null && (!Koorde.this.edges[0].equals(oldEdge) || Koorde.this.edges[nEdges - 1] == null);
                            if (!backupsToBeUpdated) continue;
                            Message reqMsg = Koorde.this.reqPredecessorMessage;
                            IDAddressPair[] updatedEdges = new IDAddressPair[Koorde.this.edges.length];
                            IDAddressPair[] iDAddressPairArray = Koorde.this.edges;
                            synchronized (iDAddressPairArray) {
                                System.arraycopy(Koorde.this.edges, 0, updatedEdges, 0, Koorde.this.edges.length);
                            }
                            int i = 0;
                            while (i < nEdges - 1) {
                                block23: {
                                    IDAddressPair pred;
                                    Message repMsg = null;
                                    if (updatedEdges[i] == null) break;
                                    if (updatedEdges[i].equals(Koorde.this.selfIDAddress)) {
                                        pred = Koorde.this.predecessor;
                                    } else {
                                        try {
                                            repMsg = Koorde.this.sender.sendAndReceive(updatedEdges[i].getAddress(), reqMsg);
                                        }
                                        catch (IOException e) {
                                            logger.warn("Failed to send a REQ_PREDECESSOR msg or receive a REP_PREDECESSOR msg.", e);
                                            Koorde.this.forget(updatedEdges, updatedEdges[i]);
                                            --i;
                                            break block23;
                                        }
                                        Serializable[] contents = repMsg.getContents();
                                        pred = (IDAddressPair)contents[0];
                                    }
                                    if (updatedEdges[i].equals(pred)) break;
                                    updatedEdges[i + 1] = pred;
                                }
                                ++i;
                            }
                            iDAddressPairArray = Koorde.this.edges;
                            synchronized (iDAddressPairArray) {
                                System.arraycopy(updatedEdges, 0, Koorde.this.edges, 0, Koorde.this.edges.length);
                            }
                        }
                        catch (RoutingException e) {
                            logger.warn("Routing failed.", e);
                        }
                    } while (!this.sleep(backupsToBeUpdated));
                    return;
                }
                catch (InterruptedException e) {
                    logger.warn("EdgeFixer interrupted and die.", e);
                }
            }
        }

        private boolean sleep(boolean backupsToBeUpdated) throws InterruptedException {
            if (backupsToBeUpdated) {
                this.interval = Koorde.this.config.getFixEdgeMinInterval();
            } else {
                this.interval <<= 1;
                if (this.interval > Koorde.this.config.getFixEdgeMaxInterval()) {
                    this.interval = Koorde.this.config.getFixEdgeMaxInterval();
                }
            }
            double playRatio = Koorde.this.config.getFixEdgeIntervalPlayRatio();
            double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * Koorde.access$12().nextDouble();
            long sleepPeriod = (long)((double)this.interval * intervalRatio);
            if (Koorde.this.config.getUseTimerInsteadOfThread()) {
                Koorde.access$13().schedule(this, System.currentTimeMillis() + sleepPeriod, true, true);
                return true;
            }
            Thread.sleep(sleepPeriod);
            return false;
        }
    }
}

