/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.koorde;

import java.math.BigInteger;
import ow.id.ID;
import ow.routing.RoutingContext;

public class KoordeRoutingContext
implements RoutingContext {
    private final int digitBits;
    private ID kshift;
    private ID i;
    private int topBitsOfLastKshift;

    KoordeRoutingContext(ID kshift, ID i, int digitBits) {
        this(kshift, i, 0, digitBits);
    }

    private KoordeRoutingContext(ID kshift, ID i, int topBitsOfLastKshift, int digitBits) {
        this.kshift = kshift;
        this.i = i;
        this.topBitsOfLastKshift = topBitsOfLastKshift;
        this.digitBits = digitBits;
    }

    public ID getKshift() {
        return this.kshift;
    }

    public ID getI() {
        return this.i;
    }

    public int getTopBitsOfLastKshift() {
        return this.topBitsOfLastKshift;
    }

    public RoutingContext next() {
        int idSize = this.kshift.getSize();
        int topBitsOfKshift = this.kshift.getBits(idSize * 8 - this.digitBits, this.digitBits);
        ID nextKshift = this.kshift.shiftLeft(this.digitBits);
        BigInteger iInteger = this.i.toBigInteger();
        iInteger = iInteger.shiftLeft(this.digitBits).or(BigInteger.valueOf(topBitsOfKshift));
        ID nextI = ID.getID(iInteger, idSize);
        return new KoordeRoutingContext(nextKshift, nextI, topBitsOfKshift, this.digitBits);
    }

    public int hashCode() {
        return this.kshift.hashCode() ^ this.i.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof KoordeRoutingContext) {
            KoordeRoutingContext c = (KoordeRoutingContext)o;
            if (this.kshift.equals(c.kshift) && this.i.equals(c.i)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[kshift:").append(this.kshift).append(",i:").append(this.i).append("]");
        return sb.toString();
    }
}

